/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.io;

import com.esotericsoftware.kryo.KryoException;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.util.UnsafeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class ByteBufferInput
extends Input {
    protected ByteBuffer niobuffer;
    protected boolean varIntsEnabled = true;
    ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    protected static final ByteOrder nativeOrder = ByteOrder.nativeOrder();

    public ByteBufferInput() {
    }

    public ByteBufferInput(int n) {
        this.capacity = n;
        this.niobuffer = ByteBuffer.allocateDirect(n);
        this.niobuffer.order(this.byteOrder);
    }

    public ByteBufferInput(ByteBuffer byteBuffer) {
        this(byteBuffer, 0, byteBuffer.position());
    }

    public ByteBufferInput(byte[] byArray) {
        this.setBuffer(byArray);
    }

    public ByteBufferInput(ByteBuffer byteBuffer, int n, int n2) {
        ByteBuffer byteBuffer2 = byteBuffer.duplicate();
        byteBuffer2.order(this.byteOrder);
        byteBuffer2.limit(n2);
        byteBuffer2.rewind();
        this.setBuffer(byteBuffer2, n, n2);
    }

    public ByteBufferInput(InputStream inputStream) {
        this(4096);
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null.");
        }
        this.inputStream = inputStream;
    }

    public ByteBufferInput(InputStream inputStream, int n) {
        this(n);
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null.");
        }
        this.inputStream = inputStream;
    }

    public ByteOrder order() {
        return this.byteOrder;
    }

    public void order(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    @Override
    public void setBuffer(byte[] byArray) {
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(byArray.length);
        byteBuffer.put(byArray);
        byteBuffer.position(0);
        byteBuffer.order(this.byteOrder);
        this.setBuffer(byteBuffer, 0, byArray.length);
    }

    public void setBuffer(ByteBuffer byteBuffer, int n, int n2) {
        if (byteBuffer == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        this.niobuffer = byteBuffer;
        this.position = n;
        this.limit = n + n2;
        this.capacity = byteBuffer.capacity();
        this.total = 0;
        this.inputStream = null;
        this.niobuffer.position(this.position);
    }

    public void release() {
        this.close();
        UnsafeUtil.releaseBuffer(this.niobuffer);
        this.niobuffer = null;
    }

    public ByteBufferInput(long l, int n) {
        this.niobuffer = UnsafeUtil.getDirectBufferAt(l, n);
        this.setBuffer(this.niobuffer, 0, n);
    }

    public ByteBuffer getByteBuffer() {
        return this.niobuffer;
    }

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.limit = 0;
        this.rewind();
    }

    @Override
    public void rewind() {
        super.rewind();
        this.niobuffer.position(0);
    }

    protected int fill(ByteBuffer byteBuffer, int n, int n2) throws KryoException {
        if (this.inputStream == null) {
            return -1;
        }
        try {
            byte[] byArray = new byte[n2];
            int n3 = this.inputStream.read(byArray, 0, n2);
            byteBuffer.position(n);
            if (n3 >= 0) {
                byteBuffer.put(byArray, 0, n3);
                byteBuffer.position(n);
            }
            return n3;
        }
        catch (IOException iOException) {
            throw new KryoException(iOException);
        }
    }

    @Override
    protected final int require(int n) throws KryoException {
        int n2;
        int n3 = this.limit - this.position;
        if (n3 >= n) {
            return n3;
        }
        if (n > this.capacity) {
            throw new KryoException("Buffer too small: capacity: " + this.capacity + ", required: " + n);
        }
        if (n3 > 0) {
            n2 = this.fill(this.niobuffer, this.limit, this.capacity - this.limit);
            if (n2 == -1) {
                throw new KryoException("Buffer underflow.");
            }
            if ((n3 += n2) >= n) {
                this.limit += n2;
                return n3;
            }
        }
        this.niobuffer.position(this.position);
        this.niobuffer.compact();
        this.total += this.position;
        this.position = 0;
        do {
            if ((n2 = this.fill(this.niobuffer, n3, this.capacity - n3)) != -1) continue;
            if (n3 >= n) break;
            throw new KryoException("Buffer underflow.");
        } while ((n3 += n2) < n);
        this.limit = n3;
        this.niobuffer.position(0);
        return n3;
    }

    private int optional(int n) throws KryoException {
        int n2 = this.limit - this.position;
        if (n2 >= n) {
            return n;
        }
        n = Math.min(n, this.capacity);
        int n3 = this.fill(this.niobuffer, this.limit, this.capacity - this.limit);
        if (n3 == -1) {
            return n2 == 0 ? -1 : Math.min(n2, n);
        }
        if ((n2 += n3) >= n) {
            this.limit += n3;
            return n;
        }
        this.niobuffer.compact();
        this.total += this.position;
        this.position = 0;
        while ((n3 = this.fill(this.niobuffer, n2, this.capacity - n2)) != -1 && (n2 += n3) < n) {
        }
        this.limit = n2;
        this.niobuffer.position(this.position);
        return n2 == 0 ? -1 : Math.min(n2, n);
    }

    @Override
    public int read() throws KryoException {
        if (this.optional(1) <= 0) {
            return -1;
        }
        this.niobuffer.position(this.position);
        ++this.position;
        return this.niobuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws KryoException {
        this.niobuffer.position(this.position);
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws KryoException {
        this.niobuffer.position(this.position);
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int n3 = n2;
        int n4 = Math.min(this.limit - this.position, n2);
        do {
            this.niobuffer.get(byArray, n, n4);
            this.position += n4;
            if ((n2 -= n4) == 0) break;
            n += n4;
            n4 = this.optional(n2);
            if (n4 != -1) continue;
            if (n3 == n2) {
                return -1;
            }
            break;
        } while (this.position != this.limit);
        return n3 - n2;
    }

    @Override
    public long skip(long l) throws KryoException {
        int n;
        for (long i = l; i > 0L; i -= (long)n) {
            n = Math.min(Integer.MAX_VALUE, (int)i);
            this.skip(n);
        }
        return l;
    }

    @Override
    public void close() throws KryoException {
        if (this.inputStream != null) {
            try {
                this.inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public byte readByte() throws KryoException {
        this.niobuffer.position(this.position);
        this.require(1);
        ++this.position;
        return this.niobuffer.get();
    }

    @Override
    public int readByteUnsigned() throws KryoException {
        this.require(1);
        ++this.position;
        return this.niobuffer.get() & 0xFF;
    }

    @Override
    public byte[] readBytes(int n) throws KryoException {
        byte[] byArray = new byte[n];
        this.readBytes(byArray, 0, n);
        return byArray;
    }

    @Override
    public void readBytes(byte[] byArray) throws KryoException {
        this.readBytes(byArray, 0, byArray.length);
    }

    @Override
    public void readBytes(byte[] byArray, int n, int n2) throws KryoException {
        if (byArray == null) {
            throw new IllegalArgumentException("bytes cannot be null.");
        }
        int n3 = Math.min(this.limit - this.position, n2);
        while (true) {
            this.niobuffer.get(byArray, n, n3);
            this.position += n3;
            if ((n2 -= n3) == 0) break;
            n += n3;
            n3 = Math.min(n2, this.capacity);
            this.require(n3);
        }
    }

    @Override
    public int readInt() throws KryoException {
        this.require(4);
        this.position += 4;
        return this.niobuffer.getInt();
    }

    @Override
    public int readInt(boolean bl) throws KryoException {
        if (this.varIntsEnabled) {
            return this.readVarInt(bl);
        }
        return this.readInt();
    }

    @Override
    public int readVarInt(boolean bl) throws KryoException {
        this.niobuffer.position(this.position);
        if (this.require(1) < 5) {
            return this.readInt_slow(bl);
        }
        ++this.position;
        byte by = this.niobuffer.get();
        int n = by & 0x7F;
        if ((by & 0x80) != 0) {
            ++this.position;
            by = this.niobuffer.get();
            n |= (by & 0x7F) << 7;
            if ((by & 0x80) != 0) {
                ++this.position;
                by = this.niobuffer.get();
                n |= (by & 0x7F) << 14;
                if ((by & 0x80) != 0) {
                    ++this.position;
                    by = this.niobuffer.get();
                    n |= (by & 0x7F) << 21;
                    if ((by & 0x80) != 0) {
                        ++this.position;
                        by = this.niobuffer.get();
                        n |= (by & 0x7F) << 28;
                    }
                }
            }
        }
        return bl ? n : n >>> 1 ^ -(n & 1);
    }

    private int readInt_slow(boolean bl) {
        ++this.position;
        byte by = this.niobuffer.get();
        int n = by & 0x7F;
        if ((by & 0x80) != 0) {
            this.require(1);
            ++this.position;
            by = this.niobuffer.get();
            n |= (by & 0x7F) << 7;
            if ((by & 0x80) != 0) {
                this.require(1);
                ++this.position;
                by = this.niobuffer.get();
                n |= (by & 0x7F) << 14;
                if ((by & 0x80) != 0) {
                    this.require(1);
                    ++this.position;
                    by = this.niobuffer.get();
                    n |= (by & 0x7F) << 21;
                    if ((by & 0x80) != 0) {
                        this.require(1);
                        ++this.position;
                        by = this.niobuffer.get();
                        n |= (by & 0x7F) << 28;
                    }
                }
            }
        }
        return bl ? n : n >>> 1 ^ -(n & 1);
    }

    @Override
    public boolean canReadInt() throws KryoException {
        if (this.limit - this.position >= 5) {
            return true;
        }
        if (this.optional(5) <= 0) {
            return false;
        }
        int n = this.position;
        if ((this.niobuffer.get(n++) & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(n++) & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(n++) & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(n++) & 0x80) == 0) {
            return true;
        }
        return n != this.limit;
    }

    @Override
    public boolean canReadLong() throws KryoException {
        if (this.limit - this.position >= 9) {
            return true;
        }
        if (this.optional(5) <= 0) {
            return false;
        }
        int n = this.position;
        if ((this.niobuffer.get(n++) & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(n++) & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(n++) & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(n++) & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(n++) & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(n++) & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(n++) & 0x80) == 0) {
            return true;
        }
        if (n == this.limit) {
            return false;
        }
        if ((this.niobuffer.get(n++) & 0x80) == 0) {
            return true;
        }
        return n != this.limit;
    }

    @Override
    public String readString() {
        this.niobuffer.position(this.position);
        int n = this.require(1);
        ++this.position;
        byte by = this.niobuffer.get();
        if ((by & 0x80) == 0) {
            return this.readAscii();
        }
        int n2 = n >= 5 ? this.readUtf8Length(by) : this.readUtf8Length_slow(by);
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: {
                return "";
            }
        }
        if (this.chars.length < --n2) {
            this.chars = new char[n2];
        }
        this.readUtf8(n2);
        return new String(this.chars, 0, n2);
    }

    private int readUtf8Length(int n) {
        int n2 = n & 0x3F;
        if ((n & 0x40) != 0) {
            ++this.position;
            n = this.niobuffer.get();
            n2 |= (n & 0x7F) << 6;
            if ((n & 0x80) != 0) {
                ++this.position;
                n = this.niobuffer.get();
                n2 |= (n & 0x7F) << 13;
                if ((n & 0x80) != 0) {
                    ++this.position;
                    n = this.niobuffer.get();
                    n2 |= (n & 0x7F) << 20;
                    if ((n & 0x80) != 0) {
                        ++this.position;
                        n = this.niobuffer.get();
                        n2 |= (n & 0x7F) << 27;
                    }
                }
            }
        }
        return n2;
    }

    private int readUtf8Length_slow(int n) {
        int n2 = n & 0x3F;
        if ((n & 0x40) != 0) {
            this.require(1);
            ++this.position;
            n = this.niobuffer.get();
            n2 |= (n & 0x7F) << 6;
            if ((n & 0x80) != 0) {
                this.require(1);
                ++this.position;
                n = this.niobuffer.get();
                n2 |= (n & 0x7F) << 13;
                if ((n & 0x80) != 0) {
                    this.require(1);
                    ++this.position;
                    n = this.niobuffer.get();
                    n2 |= (n & 0x7F) << 20;
                    if ((n & 0x80) != 0) {
                        this.require(1);
                        ++this.position;
                        n = this.niobuffer.get();
                        n2 |= (n & 0x7F) << 27;
                    }
                }
            }
        }
        return n2;
    }

    private void readUtf8(int n) {
        char[] cArray = this.chars;
        int n2 = 0;
        int n3 = Math.min(this.require(1), n);
        int n4 = this.position;
        while (n2 < n3) {
            ++n4;
            byte by = this.niobuffer.get();
            if (by < 0) {
                --n4;
                break;
            }
            cArray[n2++] = (char)by;
        }
        this.position = n4;
        if (n2 < n) {
            this.niobuffer.position(n4);
            this.readUtf8_slow(n, n2);
        }
    }

    private void readUtf8_slow(int n, int n2) {
        char[] cArray = this.chars;
        while (n2 < n) {
            if (this.position == this.limit) {
                this.require(1);
            }
            ++this.position;
            int n3 = this.niobuffer.get() & 0xFF;
            switch (n3 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n2] = (char)n3;
                    break;
                }
                case 12: 
                case 13: {
                    if (this.position == this.limit) {
                        this.require(1);
                    }
                    ++this.position;
                    cArray[n2] = (char)((n3 & 0x1F) << 6 | this.niobuffer.get() & 0x3F);
                    break;
                }
                case 14: {
                    this.require(2);
                    this.position += 2;
                    byte by = this.niobuffer.get();
                    byte by2 = this.niobuffer.get();
                    cArray[n2] = (char)((n3 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                }
            }
            ++n2;
        }
    }

    private String readAscii() {
        byte by;
        int n = this.position;
        int n2 = n - 1;
        int n3 = this.limit;
        do {
            if (n == n3) {
                return this.readAscii_slow();
            }
            ++n;
        } while (((by = this.niobuffer.get()) & 0x80) == 0);
        this.niobuffer.put(n - 1, (byte)(this.niobuffer.get(n - 1) & 0x7F));
        byte[] byArray = new byte[n - n2];
        this.niobuffer.position(n2);
        this.niobuffer.get(byArray);
        String string = new String(byArray, 0, 0, n - n2);
        this.niobuffer.put(n - 1, (byte)(this.niobuffer.get(n - 1) | 0x80));
        this.position = n;
        this.niobuffer.position(this.position);
        return string;
    }

    private String readAscii_slow() {
        --this.position;
        int n = this.limit - this.position;
        if (n > this.chars.length) {
            this.chars = new char[n * 2];
        }
        char[] cArray = this.chars;
        int n2 = this.position;
        int n3 = 0;
        int n4 = this.limit;
        while (n2 < n4) {
            cArray[n3] = (char)this.niobuffer.get(n2);
            ++n2;
            ++n3;
        }
        this.position = this.limit;
        while (true) {
            this.require(1);
            ++this.position;
            n2 = this.niobuffer.get();
            if (n == cArray.length) {
                char[] cArray2 = new char[n * 2];
                System.arraycopy(cArray, 0, cArray2, 0, n);
                cArray = cArray2;
                this.chars = cArray2;
            }
            if ((n2 & 0x80) == 128) break;
            cArray[n++] = (char)n2;
        }
        cArray[n++] = (char)(n2 & 0x7F);
        return new String(cArray, 0, n);
    }

    @Override
    public StringBuilder readStringBuilder() {
        this.niobuffer.position(this.position);
        int n = this.require(1);
        ++this.position;
        byte by = this.niobuffer.get();
        if ((by & 0x80) == 0) {
            return new StringBuilder(this.readAscii());
        }
        int n2 = n >= 5 ? this.readUtf8Length(by) : this.readUtf8Length_slow(by);
        switch (n2) {
            case 0: {
                return null;
            }
            case 1: {
                return new StringBuilder("");
            }
        }
        if (this.chars.length < --n2) {
            this.chars = new char[n2];
        }
        this.readUtf8(n2);
        StringBuilder stringBuilder = new StringBuilder(n2);
        stringBuilder.append(this.chars, 0, n2);
        return stringBuilder;
    }

    @Override
    public float readFloat() throws KryoException {
        this.require(4);
        this.position += 4;
        return this.niobuffer.getFloat();
    }

    @Override
    public float readFloat(float f, boolean bl) throws KryoException {
        return (float)this.readInt(bl) / f;
    }

    @Override
    public short readShort() throws KryoException {
        this.require(2);
        this.position += 2;
        return this.niobuffer.getShort();
    }

    @Override
    public int readShortUnsigned() throws KryoException {
        this.require(2);
        this.position += 2;
        return this.niobuffer.getShort();
    }

    @Override
    public long readLong() throws KryoException {
        this.require(8);
        this.position += 8;
        return this.niobuffer.getLong();
    }

    @Override
    public long readLong(boolean bl) throws KryoException {
        if (this.varIntsEnabled) {
            return this.readVarLong(bl);
        }
        return this.readLong();
    }

    @Override
    public long readVarLong(boolean bl) throws KryoException {
        this.niobuffer.position(this.position);
        if (this.require(1) < 9) {
            return this.readLong_slow(bl);
        }
        ++this.position;
        byte by = this.niobuffer.get();
        long l = by & 0x7F;
        if ((by & 0x80) != 0) {
            ++this.position;
            by = this.niobuffer.get();
            l |= (long)((by & 0x7F) << 7);
            if ((by & 0x80) != 0) {
                ++this.position;
                by = this.niobuffer.get();
                l |= (long)((by & 0x7F) << 14);
                if ((by & 0x80) != 0) {
                    ++this.position;
                    by = this.niobuffer.get();
                    l |= (long)((by & 0x7F) << 21);
                    if ((by & 0x80) != 0) {
                        ++this.position;
                        by = this.niobuffer.get();
                        l |= (long)(by & 0x7F) << 28;
                        if ((by & 0x80) != 0) {
                            ++this.position;
                            by = this.niobuffer.get();
                            l |= (long)(by & 0x7F) << 35;
                            if ((by & 0x80) != 0) {
                                ++this.position;
                                by = this.niobuffer.get();
                                l |= (long)(by & 0x7F) << 42;
                                if ((by & 0x80) != 0) {
                                    ++this.position;
                                    by = this.niobuffer.get();
                                    l |= (long)(by & 0x7F) << 49;
                                    if ((by & 0x80) != 0) {
                                        ++this.position;
                                        by = this.niobuffer.get();
                                        l |= (long)by << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!bl) {
            l = l >>> 1 ^ -(l & 1L);
        }
        return l;
    }

    private long readLong_slow(boolean bl) {
        ++this.position;
        byte by = this.niobuffer.get();
        long l = by & 0x7F;
        if ((by & 0x80) != 0) {
            this.require(1);
            ++this.position;
            by = this.niobuffer.get();
            l |= (long)((by & 0x7F) << 7);
            if ((by & 0x80) != 0) {
                this.require(1);
                ++this.position;
                by = this.niobuffer.get();
                l |= (long)((by & 0x7F) << 14);
                if ((by & 0x80) != 0) {
                    this.require(1);
                    ++this.position;
                    by = this.niobuffer.get();
                    l |= (long)((by & 0x7F) << 21);
                    if ((by & 0x80) != 0) {
                        this.require(1);
                        ++this.position;
                        by = this.niobuffer.get();
                        l |= (long)(by & 0x7F) << 28;
                        if ((by & 0x80) != 0) {
                            this.require(1);
                            ++this.position;
                            by = this.niobuffer.get();
                            l |= (long)(by & 0x7F) << 35;
                            if ((by & 0x80) != 0) {
                                this.require(1);
                                ++this.position;
                                by = this.niobuffer.get();
                                l |= (long)(by & 0x7F) << 42;
                                if ((by & 0x80) != 0) {
                                    this.require(1);
                                    ++this.position;
                                    by = this.niobuffer.get();
                                    l |= (long)(by & 0x7F) << 49;
                                    if ((by & 0x80) != 0) {
                                        this.require(1);
                                        ++this.position;
                                        by = this.niobuffer.get();
                                        l |= (long)by << 56;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (!bl) {
            l = l >>> 1 ^ -(l & 1L);
        }
        return l;
    }

    @Override
    public boolean readBoolean() throws KryoException {
        this.require(1);
        ++this.position;
        return this.niobuffer.get() == 1;
    }

    @Override
    public char readChar() throws KryoException {
        this.require(2);
        this.position += 2;
        return this.niobuffer.getChar();
    }

    @Override
    public double readDouble() throws KryoException {
        this.require(8);
        this.position += 8;
        return this.niobuffer.getDouble();
    }

    @Override
    public double readDouble(double d, boolean bl) throws KryoException {
        return (double)this.readLong(bl) / d;
    }

    @Override
    public int[] readInts(int n) throws KryoException {
        if (this.capacity - this.position >= n * 4 && this.isNativeOrder()) {
            int[] nArray = new int[n];
            IntBuffer intBuffer = this.niobuffer.asIntBuffer();
            intBuffer.get(nArray);
            this.position += n * 4;
            this.niobuffer.position(this.position);
            return nArray;
        }
        return super.readInts(n);
    }

    @Override
    public long[] readLongs(int n) throws KryoException {
        if (this.capacity - this.position >= n * 8 && this.isNativeOrder()) {
            long[] lArray = new long[n];
            LongBuffer longBuffer = this.niobuffer.asLongBuffer();
            longBuffer.get(lArray);
            this.position += n * 8;
            this.niobuffer.position(this.position);
            return lArray;
        }
        return super.readLongs(n);
    }

    @Override
    public float[] readFloats(int n) throws KryoException {
        if (this.capacity - this.position >= n * 4 && this.isNativeOrder()) {
            float[] fArray = new float[n];
            FloatBuffer floatBuffer = this.niobuffer.asFloatBuffer();
            floatBuffer.get(fArray);
            this.position += n * 4;
            this.niobuffer.position(this.position);
            return fArray;
        }
        return super.readFloats(n);
    }

    @Override
    public short[] readShorts(int n) throws KryoException {
        if (this.capacity - this.position >= n * 2 && this.isNativeOrder()) {
            short[] sArray = new short[n];
            ShortBuffer shortBuffer = this.niobuffer.asShortBuffer();
            shortBuffer.get(sArray);
            this.position += n * 2;
            this.niobuffer.position(this.position);
            return sArray;
        }
        return super.readShorts(n);
    }

    @Override
    public char[] readChars(int n) throws KryoException {
        if (this.capacity - this.position >= n * 2 && this.isNativeOrder()) {
            char[] cArray = new char[n];
            CharBuffer charBuffer = this.niobuffer.asCharBuffer();
            charBuffer.get(cArray);
            this.position += n * 2;
            this.niobuffer.position(this.position);
            return cArray;
        }
        return super.readChars(n);
    }

    @Override
    public double[] readDoubles(int n) throws KryoException {
        if (this.capacity - this.position >= n * 8 && this.isNativeOrder()) {
            double[] dArray = new double[n];
            DoubleBuffer doubleBuffer = this.niobuffer.asDoubleBuffer();
            doubleBuffer.get(dArray);
            this.position += n * 8;
            this.niobuffer.position(this.position);
            return dArray;
        }
        return super.readDoubles(n);
    }

    private boolean isNativeOrder() {
        return this.byteOrder == nativeOrder;
    }

    public boolean getVarIntsEnabled() {
        return this.varIntsEnabled;
    }

    public void setVarIntsEnabled(boolean bl) {
        this.varIntsEnabled = bl;
    }
}

