/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.util;

import com.intellij.openapi.util.text.StringUtil;

public class XmlStringUtil {
    private XmlStringUtil() {
    }

    public static String wrapInCDATA(String str) {
        StringBuilder sb = new StringBuilder();
        int cur = 0;
        int len = str.length();
        while (cur < len) {
            int next = StringUtil.indexOf((CharSequence)str, "]]>", cur);
            next = next < 0 ? len : next + 1;
            sb.append("<![CDATA[").append(str.subSequence(cur, next)).append("]]>");
            cur = next;
        }
        return sb.toString();
    }

    public static String escapeString(String str) {
        return XmlStringUtil.escapeString(str, false);
    }

    public static String escapeString(String str, boolean escapeWhiteSpace) {
        return XmlStringUtil.escapeString(str, escapeWhiteSpace, true);
    }

    public static String escapeString(String str, boolean escapeWhiteSpace, boolean convertNoBreakSpace) {
        if (str == null) {
            return null;
        }
        StringBuilder buffer = null;
        for (int i = 0; i < str.length(); ++i) {
            String entity;
            char ch = str.charAt(i);
            switch (ch) {
                case '\n': {
                    entity = escapeWhiteSpace ? "&#10;" : null;
                    break;
                }
                case '\r': {
                    entity = escapeWhiteSpace ? "&#13;" : null;
                    break;
                }
                case '\t': {
                    entity = escapeWhiteSpace ? "&#9;" : null;
                    break;
                }
                case '\"': {
                    entity = "&quot;";
                    break;
                }
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '\u00a0': {
                    entity = convertNoBreakSpace ? "&nbsp;" : null;
                    break;
                }
                default: {
                    entity = null;
                }
            }
            if (buffer == null) {
                if (entity == null) continue;
                buffer = new StringBuilder(str.length() + 20);
                buffer.append(str.substring(0, i));
                buffer.append(entity);
                continue;
            }
            if (entity == null) {
                buffer.append(ch);
                continue;
            }
            buffer.append(entity);
        }
        return buffer == null ? str : buffer.toString();
    }

    public static String wrapInHtml(CharSequence result) {
        return "<html>" + result + "</html>";
    }

    public static boolean isWrappedInHtml(String tooltip) {
        return StringUtil.startsWithIgnoreCase(tooltip, "<html>") && StringUtil.endsWithIgnoreCase(tooltip, "</html>");
    }

    public static String stripHtml(String toolTip) {
        toolTip = StringUtil.trimStart(toolTip, "<html>");
        toolTip = StringUtil.trimStart(toolTip, "<body>");
        toolTip = StringUtil.trimEnd(toolTip, "</html>");
        toolTip = StringUtil.trimEnd(toolTip, "</body>");
        return toolTip;
    }
}

