/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.util.io.URLUtil;
import com.intellij.util.xmlb.XIncludeException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;

public class JDOMXIncluder {
    private static final Logger LOG = Logger.getInstance(JDOMXIncluder.class);
    public static final PathResolver DEFAULT_PATH_RESOLVER = new PathResolver(){

        @Override
        public URL resolvePath(String relativePath, String base) {
            try {
                if (base != null) {
                    return new URL(new URL(base), relativePath);
                }
                return new URL(relativePath);
            }
            catch (MalformedURLException ex) {
                throw new XIncludeException(ex);
            }
        }
    };
    private static final String HTTP_WWW_W3_ORG_2001_XINCLUDE = "http://www.w3.org/2001/XInclude";
    private static final String XI = "xi";
    private static final String INCLUDE = "include";
    private static final String HREF = "href";
    private static final String BASE = "base";
    private static final String PARSE = "parse";
    private static final String TEXT = "text";
    private static final String XML = "xml";
    private static final String ENCODING = "encoding";
    private static final String XPOINTER = "xpointer";
    public static final Namespace XINCLUDE_NAMESPACE = Namespace.getNamespace((String)"xi", (String)"http://www.w3.org/2001/XInclude");
    private final boolean myIgnoreMissing;
    private final PathResolver myPathResolver;
    public static Pattern XPOINTER_PATTERN = Pattern.compile("xpointer\\((.*)\\)");
    public static Pattern CHILDREN_PATTERN = Pattern.compile("/([^/]*)(/[^/]*)?/\\*");

    private JDOMXIncluder(boolean ignoreMissing, PathResolver pathResolver) {
        this.myIgnoreMissing = ignoreMissing;
        this.myPathResolver = pathResolver;
    }

    public static Document resolve(Document original, String base) throws XIncludeException {
        return JDOMXIncluder.resolve(original, base, false);
    }

    public static Document resolve(Document original, String base, boolean ignoreMissing) throws XIncludeException {
        return JDOMXIncluder.resolve(original, base, ignoreMissing, DEFAULT_PATH_RESOLVER);
    }

    public static Document resolve(Document original, String base, boolean ignoreMissing, PathResolver pathResolver) throws XIncludeException {
        return new JDOMXIncluder(ignoreMissing, pathResolver).doResolve(original, base);
    }

    public static List<Content> resolve(Element original, String base) throws XIncludeException {
        return new JDOMXIncluder(false, DEFAULT_PATH_RESOLVER).doResolve(original, base);
    }

    private Document doResolve(Document original, String base) {
        if (original == null) {
            throw new NullPointerException("Document must not be null");
        }
        Document result = original.clone();
        Element root = result.getRootElement();
        List<Content> resolved = this.doResolve(root, base);
        Element newRoot = null;
        for (Content o : resolved) {
            if (o instanceof Element) {
                if (newRoot != null) {
                    throw new XIncludeException("Tried to include multiple roots");
                }
                newRoot = (Element)o;
                continue;
            }
            if (o instanceof Comment || o instanceof ProcessingInstruction) continue;
            if (o instanceof Text) {
                throw new XIncludeException("Tried to include text node outside of root element");
            }
            if (o instanceof EntityRef) {
                throw new XIncludeException("Tried to include a general entity reference outside of root element");
            }
            throw new XIncludeException("Unexpected type " + o.getClass());
        }
        if (newRoot == null) {
            throw new XIncludeException("No root element");
        }
        List newContent = result.getContent();
        Iterator<Content> iterator = resolved.iterator();
        int rootPosition = newContent.indexOf(result.getRootElement());
        while (iterator.hasNext()) {
            Content o = iterator.next();
            if (o instanceof Comment || o instanceof ProcessingInstruction) {
                newContent.add(rootPosition, o);
                ++rootPosition;
                continue;
            }
            if (!(o instanceof Element)) continue;
            break;
        }
        result.setRootElement(newRoot);
        int addPosition = rootPosition + 1;
        while (iterator.hasNext()) {
            Content o = iterator.next();
            if (!(o instanceof Comment) && !(o instanceof ProcessingInstruction)) continue;
            newContent.add(addPosition, o);
            ++addPosition;
        }
        return result;
    }

    private List<Content> doResolve(Element original, String base) throws XIncludeException {
        Stack<String> bases = new Stack<String>();
        if (base != null) {
            bases.push(base);
        }
        List<Content> result = this.resolve(original, bases);
        bases.pop();
        return result;
    }

    private static boolean isIncludeElement(Element element) {
        return element.getName().equals(INCLUDE) && element.getNamespace().equals((Object)XINCLUDE_NAMESPACE);
    }

    private List<Content> resolve(Element original, Stack<String> bases) throws XIncludeException {
        if (JDOMXIncluder.isIncludeElement(original)) {
            return this.resolveXIncludeElement(original, bases);
        }
        Element resolvedElement = this.resolveNonXIncludeElement(original, bases);
        ArrayList<Content> resultList = new ArrayList<Content>(1);
        resultList.add((Content)resolvedElement);
        return resultList;
    }

    private List<Content> resolveXIncludeElement(Element element, Stack<String> bases) throws XIncludeException {
        String base = "";
        if (!bases.isEmpty()) {
            base = bases.peek();
        }
        assert (JDOMXIncluder.isIncludeElement(element));
        String href = element.getAttributeValue(HREF);
        assert (href != null) : "Missing href attribute";
        Attribute baseAttribute = element.getAttribute(BASE, Namespace.XML_NAMESPACE);
        if (baseAttribute != null) {
            base = baseAttribute.getValue();
        }
        URL remote = this.myPathResolver.resolvePath(href, base);
        boolean parse = true;
        String parseAttribute = element.getAttributeValue(PARSE);
        if (parseAttribute != null) {
            if (parseAttribute.equals(TEXT)) {
                parse = false;
            }
            assert (parseAttribute.equals(XML)) : parseAttribute + "is not a legal value for the parse attribute";
        }
        if (parse) {
            assert (!bases.contains(remote.toExternalForm())) : "Circular XInclude Reference to " + remote.toExternalForm();
            Element fallbackElement = element.getChild("fallback", element.getNamespace());
            List<Content> remoteParsed = this.parseRemote(bases, remote, fallbackElement);
            if (!remoteParsed.isEmpty()) {
                remoteParsed = JDOMXIncluder.extractNeededChildren(element, remoteParsed);
            }
            for (int i = 0; i < remoteParsed.size(); ++i) {
                Content o = remoteParsed.get(i);
                if (!(o instanceof Element)) continue;
                Element e = (Element)o;
                List<Content> nodes = this.resolve(e, bases);
                remoteParsed.addAll(i, nodes);
                remoteParsed.remove(i += nodes.size());
                --i;
                e.detach();
            }
            for (Content o : remoteParsed) {
                if (!(o instanceof Content)) continue;
                Content content = o;
                content.detach();
            }
            return remoteParsed;
        }
        try {
            String encoding = element.getAttributeValue(ENCODING);
            String s = StreamUtil.readText(URLUtil.openResourceStream(remote), encoding);
            ArrayList<Content> resultList = new ArrayList<Content>(1);
            resultList.add((Content)new Text(s));
            return resultList;
        }
        catch (IOException e) {
            throw new XIncludeException(e);
        }
    }

    private static List<Content> extractNeededChildren(Element element, List<Content> remoteElements) {
        String xpointer = element.getAttributeValue(XPOINTER);
        if (xpointer != null) {
            Matcher matcher = XPOINTER_PATTERN.matcher(xpointer);
            boolean b = matcher.matches();
            assert (b) : "Unsupported XPointer: " + xpointer;
            String pointer = matcher.group(1);
            matcher = CHILDREN_PATTERN.matcher(pointer);
            b = matcher.matches();
            assert (b) : "Unsupported pointer: " + pointer;
            String rootTagName = matcher.group(1);
            assert (remoteElements.size() == 1);
            assert (remoteElements.get(0) instanceof Element);
            Element e = (Element)remoteElements.get(0);
            if (e.getName().equals(rootTagName)) {
                String subTagName = matcher.group(2);
                if (subTagName != null) {
                    e = e.getChild(subTagName.substring(1));
                }
                return new ArrayList<Content>(e.getContent());
            }
            return Collections.emptyList();
        }
        return remoteElements;
    }

    private List<Content> parseRemote(Stack<String> bases, URL remote, Element fallbackElement) {
        try {
            Document doc = JDOMUtil.loadResourceDocument(remote);
            bases.push(remote.toExternalForm());
            Element root = doc.getRootElement();
            List<Content> list = this.resolve(root, bases);
            bases.pop();
            return list;
        }
        catch (JDOMException e) {
            throw new XIncludeException(e);
        }
        catch (IOException e) {
            if (fallbackElement != null) {
                return Collections.emptyList();
            }
            if (this.myIgnoreMissing) {
                LOG.info(remote.toExternalForm() + " include ignored: " + e.getMessage());
                return Collections.emptyList();
            }
            throw new XIncludeException(e);
        }
    }

    private Element resolveNonXIncludeElement(Element original, Stack<String> bases) throws XIncludeException {
        Element result = new Element(original.getName(), original.getNamespace());
        for (Attribute a : original.getAttributes()) {
            result.setAttribute(a.clone());
        }
        for (Content o : original.getContent()) {
            if (o instanceof Element) {
                Element element = (Element)o;
                if (JDOMXIncluder.isIncludeElement(element)) {
                    result.addContent(this.resolveXIncludeElement(element, bases));
                    continue;
                }
                result.addContent(this.resolveNonXIncludeElement(element, bases));
                continue;
            }
            result.addContent(o.clone());
        }
        return result;
    }

    public static interface PathResolver {
        public URL resolvePath(String var1, String var2);
    }
}

