/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.XmlSerializationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;

class FieldAccessor
implements MutableAccessor {
    private final Field myField;

    public FieldAccessor(Field field) {
        this.myField = field;
        field.setAccessible(true);
    }

    @Override
    public Object read(Object o) {
        assert (this.myField.getDeclaringClass().isInstance(o)) : "Wrong class: " + o.getClass() + "; should be: " + this.myField.getDeclaringClass();
        try {
            return this.myField.get(o);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Reading " + this.myField, e);
        }
    }

    @Override
    public void set(Object host, Object value) {
        try {
            this.myField.set(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setBoolean(Object host, boolean value) {
        try {
            this.myField.setBoolean(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setInt(Object host, int value) {
        try {
            this.myField.setInt(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setShort(Object host, short value) {
        try {
            this.myField.setShort(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setLong(Object host, long value) {
        try {
            this.myField.setLong(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setFloat(Object host, float value) {
        try {
            this.myField.setFloat(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public void setDouble(Object host, double value) {
        try {
            this.myField.setDouble(host, value);
        }
        catch (IllegalAccessException e) {
            throw new XmlSerializationException("Writing " + this.myField, e);
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.myField.getAnnotation(annotationClass);
    }

    @Override
    public String getName() {
        return this.myField.getName();
    }

    @Override
    public Class<?> getValueClass() {
        return this.myField.getType();
    }

    @Override
    public Type getGenericType() {
        return this.myField.getGenericType();
    }

    @Override
    public boolean isFinal() {
        return Modifier.isFinal(this.myField.getModifiers());
    }

    @Override
    public void write(Object o, Object value) {
        this.set(o, value);
    }

    public String toString() {
        return "FieldAccessor[" + this.myField.getDeclaringClass() + "." + this.myField.getName() + "]";
    }
}

