/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.util.xmlb.BeanBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MultiNodeBinding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.XmlSerializationException;
import java.util.List;
import org.jdom.Element;

class AccessorBindingWrapper
extends Binding
implements MultiNodeBinding {
    private final Binding myBinding;

    public AccessorBindingWrapper(MutableAccessor accessor, Binding binding) {
        super(accessor);
        this.myBinding = binding;
    }

    @Override
    public Object serialize(Object o, Object context, SerializationFilter filter) {
        Object value = this.myAccessor.read(o);
        if (value == null) {
            throw new XmlSerializationException("Property " + this.myAccessor + " of object " + o + " (" + o.getClass() + ") must not be null");
        }
        return this.myBinding.serialize(value, context, filter);
    }

    @Override
    public Object deserialize(Object context, Element element) {
        Object currentValue = this.myAccessor.read(context);
        if (this.myBinding instanceof BeanBinding && this.myAccessor.isFinal()) {
            ((BeanBinding)this.myBinding).deserializeInto(currentValue, element, null);
        } else {
            Object deserializedValue = this.myBinding.deserialize(currentValue, element);
            if (currentValue != deserializedValue) {
                this.myAccessor.set(context, deserializedValue);
            }
        }
        return context;
    }

    @Override
    public Object deserializeList(Object context, List<Element> elements) {
        Object currentValue = this.myAccessor.read(context);
        if (this.myBinding instanceof BeanBinding && this.myAccessor.isFinal()) {
            ((BeanBinding)this.myBinding).deserializeInto(currentValue, elements.get(0), null);
        } else {
            Object deserializedValue = Binding.deserializeList(this.myBinding, currentValue, elements);
            if (currentValue != deserializedValue) {
                this.myAccessor.set(context, deserializedValue);
            }
        }
        return context;
    }

    @Override
    public boolean isMulti() {
        return this.myBinding instanceof MultiNodeBinding && ((MultiNodeBinding)((Object)this.myBinding)).isMulti();
    }

    @Override
    public boolean isBoundTo(Element element) {
        return this.myBinding.isBoundTo(element);
    }
}

