/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui;

import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TreeTraverser;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;

public class JBSwingUtilities {
    public static final Key<Iterable<? extends Component>> NOT_IN_HIERARCHY_COMPONENTS = Key.create("NOT_IN_HIERARCHY_COMPONENTS");

    public static boolean isLeftMouseButton(MouseEvent anEvent) {
        return (anEvent.getModifiersEx() & 0x400) > 0;
    }

    public static boolean isMiddleMouseButton(MouseEvent anEvent) {
        return (anEvent.getModifiersEx() & 0x800) > 0;
    }

    public static boolean isRightMouseButton(MouseEvent anEvent) {
        return (anEvent.getModifiersEx() & 0x1000) > 0;
    }

    public static TreeTraverser<Component> uiTraverser() {
        return new TreeTraverser<Component>(){

            @Override
            public Iterable<Component> children(Component c) {
                Iterable<Component> result = ContainerUtil.emptyIterable();
                if (c instanceof JMenu) {
                    result = Arrays.asList(((JMenu)c).getMenuComponents());
                } else if (c instanceof Container) {
                    result = Arrays.asList(((Container)c).getComponents());
                }
                if (c instanceof JComponent) {
                    JPopupMenu jpm;
                    JComponent jc = (JComponent)c;
                    Iterable<? extends Component> orphans = UIUtil.getClientProperty(jc, NOT_IN_HIERARCHY_COMPONENTS);
                    if (orphans != null) {
                        result = ContainerUtil.concat(result, orphans);
                    }
                    if ((jpm = jc.getComponentPopupMenu()) != null && jpm.isVisible() && jpm.getInvoker() == jc) {
                        result = ContainerUtil.concat(result, Collections.singletonList(jpm));
                    }
                }
                return result;
            }
        };
    }
}

