/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.pico;

import com.intellij.openapi.extensions.AreaPicoContainer;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FList;
import com.intellij.util.pico.AssignableToComponentAdapter;
import com.intellij.util.pico.ConstructorInjectionComponentAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.PicoException;
import org.picocontainer.PicoInitializationException;
import org.picocontainer.PicoIntrospectionException;
import org.picocontainer.PicoVerificationException;
import org.picocontainer.PicoVisitor;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.DuplicateComponentKeyRegistrationException;
import org.picocontainer.defaults.ImmutablePicoContainerProxyFactory;
import org.picocontainer.defaults.InstanceComponentAdapter;
import org.picocontainer.defaults.VerifyingVisitor;

public class DefaultPicoContainer
implements AreaPicoContainer,
Serializable {
    private final PicoContainer parent;
    private final Set<PicoContainer> children = new HashSet<PicoContainer>();
    private final Map<Object, ComponentAdapter> componentKeyToAdapterCache = ContainerUtil.newConcurrentMap();
    private final LinkedHashSetWrapper<ComponentAdapter> componentAdapters = new LinkedHashSetWrapper();
    private final Map<String, ComponentAdapter> classNameToAdapter = ContainerUtil.newConcurrentMap();
    private final AtomicReference<FList<ComponentAdapter>> nonAssignableComponentAdapters = new AtomicReference(FList.emptyList());

    public DefaultPicoContainer(PicoContainer parent) {
        this.parent = parent == null ? null : ImmutablePicoContainerProxyFactory.newProxyInstance((PicoContainer)parent);
    }

    public DefaultPicoContainer() {
        this(null);
    }

    public Collection<ComponentAdapter> getComponentAdapters() {
        return this.componentAdapters.getImmutableSet();
    }

    public Map<String, ComponentAdapter> getAssignablesCache() {
        return Collections.unmodifiableMap(this.classNameToAdapter);
    }

    private void appendNonAssignableAdaptersOfType(Class componentType, List<ComponentAdapter> result) {
        ArrayList<ComponentAdapter> comp = new ArrayList<ComponentAdapter>();
        for (ComponentAdapter componentAdapter : this.nonAssignableComponentAdapters.get()) {
            if (!ReflectionUtil.isAssignable(componentType, componentAdapter.getComponentImplementation())) continue;
            comp.add(componentAdapter);
        }
        for (int i = comp.size() - 1; i >= 0; --i) {
            ComponentAdapter adapter = (ComponentAdapter)comp.get(i);
            result.add(adapter);
        }
    }

    public final ComponentAdapter getComponentAdapter(Object componentKey) {
        ComponentAdapter adapter = this.getFromCache(componentKey);
        if (adapter == null && this.parent != null) {
            adapter = this.parent.getComponentAdapter(componentKey);
        }
        return adapter;
    }

    private ComponentAdapter getFromCache(Object componentKey) {
        ComponentAdapter adapter = this.componentKeyToAdapterCache.get(componentKey);
        if (adapter != null) {
            return adapter;
        }
        if (componentKey instanceof Class) {
            Class klass = (Class)componentKey;
            return this.componentKeyToAdapterCache.get(klass.getName());
        }
        return null;
    }

    public ComponentAdapter getComponentAdapterOfType(Class componentType) {
        ComponentAdapter adapterByKey = this.getComponentAdapter(componentType);
        if (adapterByKey != null) {
            return adapterByKey;
        }
        List<ComponentAdapter> found = this.getComponentAdaptersOfType(componentType);
        if (found.size() == 1) {
            return found.get(0);
        }
        if (found.isEmpty()) {
            if (this.parent != null) {
                return this.parent.getComponentAdapterOfType(componentType);
            }
            return null;
        }
        Object[] foundClasses = new Class[found.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = found.get(i).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(componentType, foundClasses);
    }

    public List<ComponentAdapter> getComponentAdaptersOfType(Class componentType) {
        if (componentType == null) {
            return Collections.emptyList();
        }
        if (componentType == String.class) {
            return Collections.emptyList();
        }
        SmartList<ComponentAdapter> result = new SmartList<ComponentAdapter>();
        ComponentAdapter cacheHit = this.classNameToAdapter.get(componentType.getName());
        if (cacheHit != null) {
            result.add(cacheHit);
        }
        this.appendNonAssignableAdaptersOfType(componentType, result);
        return result;
    }

    public ComponentAdapter registerComponent(ComponentAdapter componentAdapter) {
        Object componentKey = componentAdapter.getComponentKey();
        if (this.componentKeyToAdapterCache.containsKey(componentKey)) {
            throw new DuplicateComponentKeyRegistrationException(componentKey);
        }
        if (componentAdapter instanceof AssignableToComponentAdapter) {
            String classKey = ((AssignableToComponentAdapter)componentAdapter).getAssignableToClassName();
            this.classNameToAdapter.put(classKey, componentAdapter);
        } else {
            FList<ComponentAdapter> newList;
            FList<ComponentAdapter> oldList;
            while (!this.nonAssignableComponentAdapters.compareAndSet(oldList = this.nonAssignableComponentAdapters.get(), newList = oldList.prepend(componentAdapter))) {
            }
        }
        this.componentAdapters.add(componentAdapter);
        this.componentKeyToAdapterCache.put(componentKey, componentAdapter);
        return componentAdapter;
    }

    public ComponentAdapter unregisterComponent(Object componentKey) {
        ComponentAdapter adapter = this.componentKeyToAdapterCache.remove(componentKey);
        this.componentAdapters.remove(adapter);
        if (adapter instanceof AssignableToComponentAdapter) {
            this.classNameToAdapter.remove(((AssignableToComponentAdapter)adapter).getAssignableToClassName());
        } else {
            FList<ComponentAdapter> newList;
            FList<ComponentAdapter> oldList;
            while (!this.nonAssignableComponentAdapters.compareAndSet(oldList = this.nonAssignableComponentAdapters.get(), newList = oldList.without(adapter))) {
            }
        }
        return adapter;
    }

    public List getComponentInstances() throws PicoException {
        return this.getComponentInstancesOfType(Object.class);
    }

    public List getComponentInstancesOfType(Class componentType) {
        if (componentType == null) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        for (ComponentAdapter componentAdapter : this.getComponentAdapters()) {
            if (!ReflectionUtil.isAssignable(componentType, componentAdapter.getComponentImplementation())) continue;
            ContainerUtil.addIfNotNull(result, this.getInstance(componentAdapter));
        }
        return result;
    }

    public Object getComponentInstance(Object componentKey) {
        ComponentAdapter adapter = this.getFromCache(componentKey);
        if (adapter != null) {
            return this.getLocalInstance(adapter);
        }
        if (this.parent != null && (adapter = this.parent.getComponentAdapter(componentKey)) != null) {
            return this.parent.getComponentInstance(adapter.getComponentKey());
        }
        return null;
    }

    public Object getComponentInstanceOfType(Class componentType) {
        ComponentAdapter componentAdapter = this.getComponentAdapterOfType(componentType);
        return componentAdapter == null ? null : this.getInstance(componentAdapter);
    }

    private Object getInstance(ComponentAdapter componentAdapter) {
        if (this.getComponentAdapters().contains(componentAdapter)) {
            return this.getLocalInstance(componentAdapter);
        }
        if (this.parent != null) {
            return this.parent.getComponentInstance(componentAdapter.getComponentKey());
        }
        return null;
    }

    private Object getLocalInstance(ComponentAdapter componentAdapter) {
        Throwable firstLevelException = null;
        Object instance = null;
        try {
            instance = componentAdapter.getComponentInstance((PicoContainer)this);
        }
        catch (PicoInitializationException e) {
            firstLevelException = e;
        }
        catch (PicoIntrospectionException e) {
            firstLevelException = e;
        }
        if (firstLevelException != null) {
            if (this.parent != null && (instance = this.parent.getComponentInstance(componentAdapter.getComponentKey())) != null) {
                return instance;
            }
            throw firstLevelException;
        }
        return instance;
    }

    public ComponentAdapter unregisterComponentByInstance(Object componentInstance) {
        Collection<ComponentAdapter> adapters = this.getComponentAdapters();
        for (ComponentAdapter adapter : adapters) {
            Object o = this.getInstance(adapter);
            if (o == null || !o.equals(componentInstance)) continue;
            return this.unregisterComponent(adapter.getComponentKey());
        }
        return null;
    }

    public void verify() throws PicoVerificationException {
        new VerifyingVisitor().traverse((Object)this);
    }

    public void start() {
        throw new UnsupportedOperationException();
    }

    public void stop() {
        throw new UnsupportedOperationException();
    }

    public void dispose() {
        throw new UnsupportedOperationException();
    }

    public MutablePicoContainer makeChildContainer() {
        DefaultPicoContainer pc = new DefaultPicoContainer((PicoContainer)this);
        this.addChildContainer((PicoContainer)pc);
        return pc;
    }

    public boolean addChildContainer(PicoContainer child) {
        return this.children.add(child);
    }

    public boolean removeChildContainer(PicoContainer child) {
        return this.children.remove(child);
    }

    public void accept(PicoVisitor visitor) {
        visitor.visitContainer((PicoContainer)this);
        ArrayList<ComponentAdapter> adapters = new ArrayList<ComponentAdapter>(this.getComponentAdapters());
        for (ComponentAdapter adapter : adapters) {
            adapter.accept(visitor);
        }
        ArrayList<PicoContainer> allChildren = new ArrayList<PicoContainer>(this.children);
        for (PicoContainer child : allChildren) {
            child.accept(visitor);
        }
    }

    public ComponentAdapter registerComponentInstance(Object component) {
        return this.registerComponentInstance(component.getClass(), component);
    }

    public ComponentAdapter registerComponentInstance(Object componentKey, Object componentInstance) {
        return this.registerComponent((ComponentAdapter)new InstanceComponentAdapter(componentKey, componentInstance));
    }

    public ComponentAdapter registerComponentImplementation(Class componentImplementation) {
        return this.registerComponentImplementation(componentImplementation, componentImplementation);
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation) {
        return this.registerComponentImplementation(componentKey, componentImplementation, null);
    }

    public ComponentAdapter registerComponentImplementation(Object componentKey, Class componentImplementation, Parameter[] parameters) {
        ConstructorInjectionComponentAdapter componentAdapter = new ConstructorInjectionComponentAdapter(componentKey, componentImplementation, parameters, true);
        return this.registerComponent((ComponentAdapter)componentAdapter);
    }

    public PicoContainer getParent() {
        return this.parent;
    }

    private static class LinkedHashSetWrapper<T> {
        private final Object lock = new Object();
        private volatile Set<T> immutableSet;
        private LinkedHashSet<T> synchronizedSet = new LinkedHashSet();

        private LinkedHashSetWrapper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(T element) {
            Object object = this.lock;
            synchronized (object) {
                if (!this.synchronizedSet.contains(element)) {
                    this.copySyncSetIfExposedAsImmutable().add(element);
                }
            }
        }

        private LinkedHashSet<T> copySyncSetIfExposedAsImmutable() {
            if (this.immutableSet != null) {
                this.immutableSet = null;
                this.synchronizedSet = new LinkedHashSet<T>(this.synchronizedSet);
            }
            return this.synchronizedSet;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void remove(T element) {
            Object object = this.lock;
            synchronized (object) {
                this.copySyncSetIfExposedAsImmutable().remove(element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<T> getImmutableSet() {
            Set<T> res = this.immutableSet;
            if (res == null) {
                Object object = this.lock;
                synchronized (object) {
                    res = this.immutableSet;
                    if (res == null) {
                        this.immutableSet = res = Collections.unmodifiableSet(this.synchronizedSet);
                    }
                }
            }
            return res;
        }
    }
}

