/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.lang;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.CachePoolImpl;
import com.intellij.util.lang.ClassPath;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import sun.misc.Resource;

public class UrlClassLoader
extends ClassLoader {
    private static final boolean INDEX_PERSISTENCE_ENABLED = Boolean.parseBoolean(System.getProperty("idea.classpath.index.enabled", "true"));
    static final String CLASS_EXTENSION = ".class";
    private final List<URL> myURLs;
    private final ClassPath myClassPath;
    private final boolean myAllowBootstrapResources;

    protected ClassPath getClassPath() {
        return this.myClassPath;
    }

    public static Builder build() {
        return new Builder();
    }

    public UrlClassLoader(ClassLoader parent) {
        this(UrlClassLoader.build().urls(((URLClassLoader)parent).getURLs()).parent(parent.getParent()).allowLock().useCache().usePersistentClasspathIndexForLocalClassDirectories());
    }

    public UrlClassLoader(List<URL> urls, ClassLoader parent) {
        this(UrlClassLoader.build().urls(urls).parent(parent));
    }

    public UrlClassLoader(URL[] urls, ClassLoader parent) {
        this(UrlClassLoader.build().urls(urls).parent(parent));
    }

    public UrlClassLoader(List<URL> urls, ClassLoader parent, boolean lockJars, boolean useCache) {
        this(UrlClassLoader.build().urls(urls).parent(parent).allowLock(lockJars).useCache(useCache));
    }

    public UrlClassLoader(List<URL> urls, ClassLoader parent, boolean lockJars, boolean useCache, boolean allowUnescaped, boolean preload) {
        this(UrlClassLoader.build().urls(urls).parent(parent).allowLock(lockJars).useCache(useCache).allowUnescaped(allowUnescaped).preload(preload));
    }

    protected UrlClassLoader(Builder builder) {
        super(builder.myParent);
        this.myURLs = ContainerUtil.map(builder.myURLs, new Function<URL, URL>(){

            @Override
            public URL fun(URL url) {
                return UrlClassLoader.internProtocol(url);
            }
        });
        this.myClassPath = this.createClassPath(builder);
        this.myAllowBootstrapResources = builder.myAllowBootstrapResources;
    }

    protected final ClassPath createClassPath(Builder builder) {
        return new ClassPath(this.myURLs, builder.myLockJars, builder.myUseCache, builder.myAcceptUnescaped, builder.myPreload, builder.myUsePersistentClasspathIndex, builder.myCachePool, builder.myCachingCondition);
    }

    public static URL internProtocol(URL url) {
        try {
            String protocol = url.getProtocol();
            if ("file".equals(protocol) || "jar".equals(protocol)) {
                return new URL(protocol.intern(), url.getHost(), url.getPort(), url.getFile());
            }
            return url;
        }
        catch (MalformedURLException e) {
            Logger.getInstance(UrlClassLoader.class).error(e);
            return null;
        }
    }

    public void addURL(URL url) {
        this.getClassPath().addURL(url);
        this.myURLs.add(url);
    }

    public List<URL> getUrls() {
        return Collections.unmodifiableList(this.myURLs);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        Resource res = this.getClassPath().getResource(name.replace('.', '/').concat(CLASS_EXTENSION), false);
        if (res == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            return this.defineClass(name, res);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    protected Class _findClass(String name) {
        Resource res = this.getClassPath().getResource(name.replace('.', '/').concat(CLASS_EXTENSION), false);
        if (res == null) {
            return null;
        }
        try {
            return this.defineClass(name, res);
        }
        catch (IOException e) {
            return null;
        }
    }

    private Class defineClass(String name, Resource res) throws IOException {
        String pkgName;
        Package pkg;
        int i = name.lastIndexOf(46);
        if (i != -1 && (pkg = this.getPackage(pkgName = name.substring(0, i))) == null) {
            try {
                this.definePackage(pkgName, null, null, null, null, null, null, null);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        byte[] b = res.getBytes();
        return this._defineClass(name, b);
    }

    protected Class _defineClass(String name, byte[] b) {
        return this.defineClass(name, b, 0, b.length);
    }

    @Override
    public URL findResource(String name) {
        return this.findResourceImpl(name);
    }

    protected URL findResourceImpl(String name) {
        Resource res = this._getResource(name);
        return res != null ? res.getURL() : null;
    }

    private Resource _getResource(String name) {
        String n = name;
        if (n.startsWith("/")) {
            n = n.substring(1);
        }
        return this.getClassPath().getResource(n, true);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        if (this.myAllowBootstrapResources) {
            return super.getResourceAsStream(name);
        }
        try {
            Resource res = this._getResource(name);
            if (res == null) {
                return null;
            }
            return res.getInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        return this.getClassPath().getResources(name, true);
    }

    public static void loadPlatformLibrary(String libName) {
        String libFileName = UrlClassLoader.mapLibraryName(libName);
        String libPath = PathManager.getBinPath() + "/" + libFileName;
        if (!new File(libPath).exists()) {
            String platform = UrlClassLoader.getPlatformName();
            libPath = PathManager.getHomePath() + "/community/bin/" + platform + libFileName;
            if (!(new File(libPath).exists() || new File(libPath = PathManager.getHomePath() + "/bin/" + platform + libFileName).exists() || new File(libPath = PathManager.getHomePathFor(IdeaWin32.class) + "/bin/" + libFileName).exists())) {
                File libDir = new File(PathManager.getBinPath());
                throw new UnsatisfiedLinkError("'" + libFileName + "' not found in '" + libDir + "' among " + Arrays.toString(libDir.list()));
            }
        }
        System.load(libPath);
    }

    private static String mapLibraryName(String libName) {
        String baseName = libName;
        if (SystemInfo.is64Bit) {
            baseName = baseName.replace("32", "") + "64";
        }
        String fileName = System.mapLibraryName(baseName);
        if (SystemInfo.isMac) {
            fileName = fileName.replace(".jnilib", ".dylib");
        }
        return fileName;
    }

    private static String getPlatformName() {
        if (SystemInfo.isWindows) {
            return "win/";
        }
        if (SystemInfo.isMac) {
            return "mac/";
        }
        if (SystemInfo.isLinux) {
            return "linux/";
        }
        return "";
    }

    public static CachePool createCachePool() {
        return new CachePoolImpl();
    }

    static {
        boolean parallelLoader = Boolean.parseBoolean(System.getProperty("idea.parallel.class.loader", "true"));
        if (parallelLoader) {
            try {
                Method registerAsParallelCapable = ClassLoader.class.getDeclaredMethod("registerAsParallelCapable", new Class[0]);
                registerAsParallelCapable.setAccessible(true);
                registerAsParallelCapable.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static interface CachingCondition {
        public boolean shouldCacheData(URL var1);
    }

    public static interface CachePool {
    }

    public static final class Builder {
        private List<URL> myURLs = ContainerUtil.emptyList();
        private ClassLoader myParent = null;
        private boolean myLockJars = false;
        private boolean myUseCache = false;
        private boolean myUsePersistentClasspathIndex = false;
        private boolean myAcceptUnescaped = false;
        private boolean myPreload = true;
        private boolean myAllowBootstrapResources = false;
        private CachePoolImpl myCachePool = null;
        private CachingCondition myCachingCondition = null;

        private Builder() {
        }

        public Builder urls(List<URL> urls) {
            this.myURLs = urls;
            return this;
        }

        public Builder urls(URL ... urls) {
            this.myURLs = Arrays.asList(urls);
            return this;
        }

        public Builder parent(ClassLoader parent) {
            this.myParent = parent;
            return this;
        }

        public Builder allowLock() {
            this.myLockJars = true;
            return this;
        }

        public Builder allowLock(boolean lockJars) {
            this.myLockJars = lockJars;
            return this;
        }

        public Builder useCache() {
            this.myUseCache = true;
            return this;
        }

        public Builder useCache(boolean useCache) {
            this.myUseCache = useCache;
            return this;
        }

        public Builder usePersistentClasspathIndexForLocalClassDirectories() {
            this.myUsePersistentClasspathIndex = INDEX_PERSISTENCE_ENABLED;
            return this;
        }

        public Builder useCache(CachePool pool, CachingCondition condition) {
            this.myUseCache = true;
            this.myCachePool = (CachePoolImpl)pool;
            this.myCachingCondition = condition;
            return this;
        }

        public Builder allowUnescaped() {
            this.myAcceptUnescaped = true;
            return this;
        }

        public Builder allowUnescaped(boolean acceptUnescaped) {
            this.myAcceptUnescaped = acceptUnescaped;
            return this;
        }

        public Builder noPreload() {
            this.myPreload = false;
            return this;
        }

        public Builder preload(boolean preload) {
            this.myPreload = preload;
            return this;
        }

        public Builder allowBootstrapResources() {
            this.myAllowBootstrapResources = true;
            return this;
        }

        public UrlClassLoader get() {
            return new UrlClassLoader(this);
        }
    }
}

