/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.keyFMap;

import com.intellij.openapi.util.Key;
import com.intellij.util.keyFMap.ArrayBackedFMap;
import com.intellij.util.keyFMap.KeyFMap;
import com.intellij.util.keyFMap.OneElementFMap;

class PairElementsFMap
implements KeyFMap {
    private final Key key1;
    private final Key key2;
    private final Object value1;
    private final Object value2;

    PairElementsFMap(Key key1, Object value1, Key key2, Object value2) {
        this.key1 = key1;
        this.value1 = value1;
        this.key2 = key2;
        this.value2 = value2;
        assert (key1 != key2);
    }

    @Override
    public <V> KeyFMap plus(Key<V> key, V value) {
        if (key == this.key1) {
            return new PairElementsFMap(key, value, this.key2, this.value2);
        }
        if (key == this.key2) {
            return new PairElementsFMap(key, value, this.key1, this.value1);
        }
        return new ArrayBackedFMap(new int[]{this.key1.hashCode(), this.key2.hashCode(), key.hashCode()}, new Object[]{this.value1, this.value2, value});
    }

    @Override
    public KeyFMap minus(Key<?> key) {
        if (key == this.key1) {
            return new OneElementFMap<Object>(this.key2, this.value2);
        }
        if (key == this.key2) {
            return new OneElementFMap<Object>(this.key1, this.value1);
        }
        return this;
    }

    @Override
    public <V> V get(Key<V> key) {
        return (V)(key == this.key1 ? this.value1 : (key == this.key2 ? this.value2 : null));
    }

    @Override
    public Key[] getKeys() {
        return new Key[]{this.key1, this.key2};
    }

    @Override
    public String toString() {
        return "Pair: (" + this.key1 + " -> " + this.value1 + "; " + this.key2 + " -> " + this.value2 + ")";
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

