/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.util.EventDispatcher;
import gnu.trove.THashSet;
import java.util.EventListener;
import java.util.Set;

public class HeavyProcessLatch {
    public static final HeavyProcessLatch INSTANCE = new HeavyProcessLatch();
    private final Set<String> myHeavyProcesses = new THashSet();
    private final EventDispatcher<HeavyProcessListener> myEventDispatcher = EventDispatcher.create(HeavyProcessListener.class);

    private HeavyProcessLatch() {
    }

    @Deprecated
    public void processStarted() {
        this.processStarted("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessToken processStarted(final String operationName) {
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            this.myHeavyProcesses.add(operationName);
        }
        this.myEventDispatcher.getMulticaster().processStarted();
        return new AccessToken(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void finish() {
                Set set = HeavyProcessLatch.this.myHeavyProcesses;
                synchronized (set) {
                    HeavyProcessLatch.this.myHeavyProcesses.remove(operationName);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void processFinished() {
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            this.myHeavyProcesses.remove("");
        }
        this.myEventDispatcher.getMulticaster().processFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            return !this.myHeavyProcesses.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRunningOperationName() {
        Set<String> set = this.myHeavyProcesses;
        synchronized (set) {
            return this.myHeavyProcesses.isEmpty() ? null : this.myHeavyProcesses.iterator().next();
        }
    }

    public void addListener(Disposable parentDisposable, HeavyProcessListener listener) {
        this.myEventDispatcher.addListener(listener, parentDisposable);
    }

    public static interface HeavyProcessListener
    extends EventListener {
        public void processStarted();

        public void processFinished();
    }
}

