/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.AbstractStringEnumerator;
import com.intellij.util.io.CachingEnumerator;
import com.intellij.util.io.DataEnumerator;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.PagedFileStorage;
import com.intellij.util.io.PersistentEnumeratorDelegate;
import java.io.File;
import java.io.IOException;

public class PersistentStringEnumerator
extends PersistentEnumeratorDelegate<String>
implements AbstractStringEnumerator {
    private final CachingEnumerator<String> myCache;

    public PersistentStringEnumerator(File file) throws IOException {
        this(file, null);
    }

    public PersistentStringEnumerator(File file, PagedFileStorage.StorageLockContext storageLockContext) throws IOException {
        this(file, 4096, storageLockContext);
    }

    public PersistentStringEnumerator(File file, boolean cacheLastMappings) throws IOException {
        this(file, 4096, cacheLastMappings, null);
    }

    public PersistentStringEnumerator(File file, int initialSize) throws IOException {
        this(file, initialSize, null);
    }

    public PersistentStringEnumerator(File file, int initialSize, PagedFileStorage.StorageLockContext lockContext) throws IOException {
        this(file, initialSize, false, lockContext);
    }

    private PersistentStringEnumerator(File file, int initialSize, boolean cacheLastMappings, PagedFileStorage.StorageLockContext lockContext) throws IOException {
        super(file, EnumeratorStringDescriptor.INSTANCE, initialSize, lockContext);
        this.myCache = cacheLastMappings ? new CachingEnumerator<String>(new DataEnumerator<String>(){

            @Override
            public int enumerate(String value) throws IOException {
                return PersistentStringEnumerator.super.enumerate(value);
            }

            @Override
            public String valueOf(int idx) throws IOException {
                return (String)PersistentStringEnumerator.super.valueOf(idx);
            }
        }, EnumeratorStringDescriptor.INSTANCE) : null;
    }

    @Override
    public int enumerate(String value) throws IOException {
        return this.myCache != null ? this.myCache.enumerate(value) : super.enumerate(value);
    }

    @Override
    public String valueOf(int idx) throws IOException {
        return this.myCache != null ? this.myCache.valueOf(idx) : (String)super.valueOf(idx);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.myCache != null) {
            this.myCache.close();
        }
    }

    @Override
    public void markCorrupted() {
        this.myEnumerator.markCorrupted();
    }
}

