/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;

public abstract class OutputReader
extends BaseOutputReader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.util.io.OutputReader");
    private final Semaphore myReadFullySemaphore = new Semaphore();

    public OutputReader(InputStream inputStream, Charset charset, BaseDataReader.SleepingPolicy sleepingPolicy) {
        super(inputStream, charset, sleepingPolicy);
        this.start();
    }

    public OutputReader(InputStream inputStream, Charset charset) {
        super(inputStream, charset);
        this.start();
    }

    @Deprecated
    public OutputReader(Reader reader) {
        super(reader);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() {
        try {
            while (true) {
                boolean read;
                if (!(read = this.readAvailable())) {
                    this.myReadFullySemaphore.up();
                }
                if (this.isStopped) {
                    break;
                }
                Thread.sleep(this.mySleepingPolicy.getTimeToSleep(read));
            }
        }
        catch (InterruptedException ignore) {
        }
        catch (IOException e) {
            LOG.info(e);
        }
        catch (Exception e) {
            LOG.error(e);
        }
        finally {
            try {
                this.myReader.close();
            }
            catch (IOException e) {
                LOG.warn("Can't close reader", e);
            }
        }
    }

    public void readFully() throws InterruptedException {
        this.myReadFullySemaphore.down();
        while (!this.myReadFullySemaphore.waitForUnsafe(10L)) {
            if (!this.isStopped) continue;
            this.waitFor();
            return;
        }
    }
}

