/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.KeyDescriptor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class InlineKeyDescriptor<T>
implements KeyDescriptor<T> {
    private final boolean myCompactFormat = this.isCompactFormat();

    protected boolean isCompactFormat() {
        return false;
    }

    @Override
    public final int getHashCode(T value) {
        return this.toInt(value);
    }

    @Override
    public final boolean isEqual(T val1, T val2) {
        return this.toInt(val1) == this.toInt(val2);
    }

    @Override
    public final void save(DataOutput out, T value) throws IOException {
        int v = this.toInt(value);
        if (this.myCompactFormat) {
            DataInputOutputUtil.writeINT(out, v);
        } else {
            out.writeInt(v);
        }
    }

    @Override
    public final T read(DataInput in) throws IOException {
        int n = this.myCompactFormat ? DataInputOutputUtil.readINT(in) : in.readInt();
        return this.fromInt(n);
    }

    public abstract T fromInt(int var1);

    public abstract int toInt(T var1);
}

