/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.reference.SoftReference;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.StringInterner;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;

public class WeakStringInterner
extends StringInterner {
    private final ConcurrentMap<String, WeakReference<String>> myMap = ContainerUtil.createConcurrentWeakMap();

    @Override
    public String intern(String name) {
        WeakReference<String> key = new WeakReference<String>(name);
        String interned = (String)SoftReference.dereference(ConcurrencyUtil.cacheOrGet(this.myMap, name, key));
        if (interned != null) {
            return interned;
        }
        this.myMap.put(name, key);
        return name;
    }

    @Override
    public void clear() {
        this.myMap.clear();
    }

    @Override
    public Set<String> getValues() {
        HashSet<String> result = ContainerUtil.newHashSet();
        for (WeakReference value : this.myMap.values()) {
            ContainerUtil.addIfNotNull(result, value.get());
        }
        return result;
    }
}

