/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Processor;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.Queue;
import gnu.trove.Equality;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;

public class TransferToEDTQueue<T> {
    private final String myName;
    private final Processor<T> myProcessor;
    private volatile boolean stopped;
    private final Condition<?> myShutUpCondition;
    private final int myMaxUnitOfWorkThresholdMs;
    private final Queue<T> myQueue = new Queue(10);
    private final AtomicBoolean invokeLaterScheduled = new AtomicBoolean();
    private final Runnable myUpdateRunnable = new Runnable(){

        @Override
        public void run() {
            boolean b = TransferToEDTQueue.this.invokeLaterScheduled.compareAndSet(true, false);
            assert (b);
            if (TransferToEDTQueue.this.stopped || TransferToEDTQueue.this.myShutUpCondition.value(null)) {
                TransferToEDTQueue.this.stop();
                return;
            }
            long start = System.currentTimeMillis();
            int processed = 0;
            while (TransferToEDTQueue.this.processNext()) {
                ++processed;
                long finish = System.currentTimeMillis();
                if (TransferToEDTQueue.this.myMaxUnitOfWorkThresholdMs == -1 || finish - start <= (long)TransferToEDTQueue.this.myMaxUnitOfWorkThresholdMs) continue;
                break;
            }
            if (!TransferToEDTQueue.this.isEmpty()) {
                TransferToEDTQueue.this.scheduleUpdate();
            }
        }
    };

    public TransferToEDTQueue(String name, Processor<T> processor, Condition<?> shutUpCondition, int maxUnitOfWorkThresholdMs) {
        this.myName = name;
        this.myProcessor = processor;
        this.myShutUpCondition = shutUpCondition;
        this.myMaxUnitOfWorkThresholdMs = maxUnitOfWorkThresholdMs;
    }

    public static TransferToEDTQueue<Runnable> createRunnableMerger(String name, int maxUnitOfWorkThresholdMs) {
        return new TransferToEDTQueue<Runnable>(name, new Processor<Runnable>(){

            @Override
            public boolean process(Runnable runnable) {
                runnable.run();
                return true;
            }
        }, Conditions.alwaysFalse(), maxUnitOfWorkThresholdMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isEmpty() {
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            return this.myQueue.isEmpty();
        }
    }

    private boolean processNext() {
        T thing = this.pullFirst();
        if (thing == null) {
            return false;
        }
        if (!this.myProcessor.process(thing)) {
            this.stop();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T pullFirst() {
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            return this.myQueue.isEmpty() ? null : (T)this.myQueue.pullFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(T thing) {
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            this.myQueue.addLast(thing);
        }
        this.scheduleUpdate();
        return true;
    }

    public boolean offerIfAbsent(T thing) {
        return this.offerIfAbsent(thing, Equality.CANONICAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offerIfAbsent(final T thing, final Equality<T> equality) {
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            boolean absent = this.myQueue.process(new Processor<T>(){

                @Override
                public boolean process(T t) {
                    return !equality.equals(t, thing);
                }
            });
            if (absent) {
                this.myQueue.addLast(thing);
                this.scheduleUpdate();
            }
            return absent;
        }
    }

    private void scheduleUpdate() {
        if (!this.stopped && this.invokeLaterScheduled.compareAndSet(false, true)) {
            this.schedule(this.myUpdateRunnable);
        }
    }

    protected void schedule(Runnable updateRunnable) {
        SwingUtilities.invokeLater(updateRunnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.stopped = true;
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            this.myQueue.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            return this.myQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<T> dump() {
        Queue<T> queue = this.myQueue;
        synchronized (queue) {
            return this.myQueue.toList();
        }
    }

    public void drain() {
        int processed = 0;
        long start = System.currentTimeMillis();
        while (this.processNext()) {
            ++processed;
        }
        long finish = System.currentTimeMillis();
    }

    public void waitFor() {
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        this.schedule(new Runnable(){

            @Override
            public void run() {
                semaphore.up();
            }
        });
        semaphore.waitFor();
    }
}

