/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import java.util.ArrayList;
import java.util.List;

public interface ReadonlyList<T> {
    public static final ReadonlyList EMPTY = new ReadonlyList(){

        public Object get(int idx) {
            return null;
        }

        @Override
        public int getSize() {
            return 0;
        }
    };

    public T get(int var1);

    public int getSize();

    public static class ArrayListWrapper<T>
    implements ReadonlyList<T> {
        private final List<T> myDelegate;

        public ArrayListWrapper(List<T> delegate) {
            this.myDelegate = delegate;
        }

        public ArrayListWrapper() {
            this.myDelegate = new ArrayList<T>();
        }

        @Override
        public T get(int idx) {
            return this.myDelegate.get(idx);
        }

        @Override
        public int getSize() {
            return this.myDelegate.size();
        }

        public List<T> getDelegate() {
            return this.myDelegate;
        }
    }
}

