/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.FilteringIterator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class FluentIterable<E>
implements Iterable<E> {
    private final Iterable<E> myIterable;

    protected FluentIterable() {
        this.myIterable = this;
    }

    FluentIterable(Iterable<E> iterable) {
        this.myIterable = iterable;
    }

    public static <E> FluentIterable<E> from(final Iterable<E> iterable) {
        return iterable instanceof FluentIterable ? (FluentIterable<E>)iterable : new FluentIterable<E>(iterable){

            @Override
            public Iterator<E> iterator() {
                return iterable.iterator();
            }
        };
    }

    public static <E> FluentIterable<E> of(E[] elements) {
        return FluentIterable.from(ContainerUtil.newArrayList(elements));
    }

    public String toString() {
        return ContainerUtil.toCollection(this.myIterable).toString();
    }

    public final int size() {
        int count = 0;
        for (E ignored : this.myIterable) {
            ++count;
        }
        return count;
    }

    public final boolean contains(Object element) {
        if (this.myIterable instanceof Collection) {
            return ((Collection)this.myIterable).contains(element);
        }
        for (E e : this.myIterable) {
            if (!Comparing.equal(e, element)) continue;
            return true;
        }
        return false;
    }

    public final FluentIterable<E> append(Iterable<? extends E> other) {
        return FluentIterable.from(ContainerUtil.concat(this.myIterable, other));
    }

    public final FluentIterable<E> append(E ... elements) {
        return this.append((Iterable<? extends E>)Arrays.asList(elements));
    }

    public final FluentIterable<E> filter(final Condition<? super E> condition) {
        return FluentIterable.from(new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return FilteringIterator.create(FluentIterable.this.iterator(), condition);
            }
        });
    }

    public final <T> FluentIterable<T> filter(Class<T> type) {
        return this.filter(Conditions.instanceOf(type));
    }

    public final <T> FluentIterable<T> transform(final Function<? super E, T> function) {
        return FluentIterable.from(new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                final Iterator iterator = FluentIterable.this.iterator();
                return new Iterator<T>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public T next() {
                        return function.fun(iterator.next());
                    }

                    @Override
                    public void remove() {
                        iterator.remove();
                    }
                };
            }
        });
    }

    public final E first() {
        Iterator<E> iterator = this.myIterable.iterator();
        return iterator.hasNext() ? (E)iterator.next() : null;
    }

    public final E last() {
        if (this.myIterable instanceof List) {
            return (E)ContainerUtil.getLastItem((List)this.myIterable);
        }
        Iterator<E> iterator = this.myIterable.iterator();
        E cur = null;
        while (iterator.hasNext()) {
            cur = iterator.next();
        }
        return cur;
    }

    public final boolean isEmpty() {
        return !this.myIterable.iterator().hasNext();
    }

    public final List<E> toList() {
        return Collections.unmodifiableList(ContainerUtil.newArrayList(this.myIterable));
    }

    public final Set<E> toSet() {
        return Collections.unmodifiableSet(ContainerUtil.newHashSet(this.myIterable));
    }

    public final <V> Map<E, V> toMap(Convertor<E, V> valueFunction) {
        return Collections.unmodifiableMap(ContainerUtil.newMapFromKeys(this.iterator(), valueFunction));
    }

    public final <C extends Collection<? super E>> C copyInto(C collection) {
        if (this.myIterable instanceof Collection) {
            collection.addAll((Collection)this.myIterable);
        } else {
            for (E item : this.myIterable) {
                collection.add(item);
            }
        }
        return collection;
    }
}

