/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ConcurrentRefValueHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;

public final class ConcurrentWeakValueHashMap<K, V>
extends ConcurrentRefValueHashMap<K, V> {
    public ConcurrentWeakValueHashMap(Map<K, V> map) {
        super(map);
    }

    public ConcurrentWeakValueHashMap() {
    }

    public ConcurrentWeakValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        super(initialCapacity, loadFactor, concurrencyLevel);
    }

    public ConcurrentWeakValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, TObjectHashingStrategy<K> hashingStrategy) {
        super(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @Override
    protected ConcurrentRefValueHashMap.ValueReference<K, V> createValueReference(K key, V value) {
        return new MyWeakReference(key, value, this.myQueue);
    }

    private static class MyWeakReference<K, T>
    extends WeakReference<T>
    implements ConcurrentRefValueHashMap.ValueReference<K, T> {
        private final K key;

        private MyWeakReference(K key, T referent, ReferenceQueue<T> q) {
            super(referent, q);
            this.key = key;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConcurrentRefValueHashMap.ValueReference that = (ConcurrentRefValueHashMap.ValueReference)o;
            return this.key.equals(that.getKey()) && Comparing.equal(this.get(), that.get());
        }

        public final int hashCode() {
            return this.key.hashCode();
        }
    }
}

