/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ConcurrentWeakKeySoftValueHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;

class ConcurrentWeakKeyWeakValueHashMap<K, V>
extends ConcurrentWeakKeySoftValueHashMap<K, V> {
    ConcurrentWeakKeyWeakValueHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, TObjectHashingStrategy<K> hashingStrategy) {
        super(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    @Override
    protected ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> createKeyReference(K k, V v) {
        ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> valueReference = this.createValueReference(v, this.myValueQueue);
        ConcurrentWeakKeySoftValueHashMap.WeakKey<K, V> keyReference = new ConcurrentWeakKeySoftValueHashMap.WeakKey<K, V>(k, valueReference, this.myHashingStrategy, this.myKeyQueue);
        if (valueReference instanceof WeakValue) {
            ((WeakValue)valueReference).myKeyReference = keyReference;
        }
        return keyReference;
    }

    @Override
    protected ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> createValueReference(V value, ReferenceQueue<V> queue) {
        return new WeakValue(value, queue);
    }

    private static class WeakValue<K, V>
    extends WeakReference<V>
    implements ConcurrentWeakKeySoftValueHashMap.ValueReference<K, V> {
        private volatile ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> myKeyReference;
        private final int myHash;

        private WeakValue(V value, ReferenceQueue<V> queue) {
            super(value, queue);
            this.myHash = value.hashCode();
        }

        public final boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            ConcurrentWeakKeySoftValueHashMap.ValueReference that = (ConcurrentWeakKeySoftValueHashMap.ValueReference)o;
            return this.myHash == that.hashCode() && Comparing.equal(this.get(), that.get());
        }

        public final int hashCode() {
            return this.myHash;
        }

        @Override
        public ConcurrentWeakKeySoftValueHashMap.KeyReference<K, V> getKeyReference() {
            return this.myKeyReference;
        }
    }
}

