/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.ConcurrentRefHashMap;
import gnu.trove.TObjectHashingStrategy;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Map;

final class ConcurrentSoftHashMap<K, V>
extends ConcurrentRefHashMap<K, V> {
    @Override
    protected ConcurrentRefHashMap.KeyReference<K, V> createKeyReference(K key, V value, TObjectHashingStrategy<K> hashingStrategy) {
        return new SoftKey(key, hashingStrategy.computeHashCode(key), hashingStrategy, value, this.myReferenceQueue);
    }

    public ConcurrentSoftHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public ConcurrentSoftHashMap(int initialCapacity) {
        super(initialCapacity);
    }

    public ConcurrentSoftHashMap() {
    }

    public ConcurrentSoftHashMap(int initialCapacity, float loadFactor, int concurrencyLevel, TObjectHashingStrategy<K> hashingStrategy) {
        super(initialCapacity, loadFactor, concurrencyLevel, hashingStrategy);
    }

    public ConcurrentSoftHashMap(Map<? extends K, ? extends V> t) {
        super(t);
    }

    public ConcurrentSoftHashMap(TObjectHashingStrategy<K> hashingStrategy) {
        super(hashingStrategy);
    }

    private static class SoftKey<K, V>
    extends SoftReference<K>
    implements ConcurrentRefHashMap.KeyReference<K, V> {
        private final int myHash;
        private final TObjectHashingStrategy<K> myStrategy;
        private final V value;

        private SoftKey(K k, int hash, TObjectHashingStrategy<K> strategy, V v, ReferenceQueue<K> q) {
            super(k, q);
            this.myStrategy = strategy;
            this.value = v;
            this.myHash = hash;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public boolean equals(Object o) {
            Object u;
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConcurrentRefHashMap.KeyReference)) {
                return false;
            }
            Object t = this.get();
            if (t == (u = ((ConcurrentRefHashMap.KeyReference)o).get())) {
                return true;
            }
            if (t == null || u == null) {
                return false;
            }
            return this.myStrategy.equals(t, u);
        }

        @Override
        public int hashCode() {
            return this.myHash;
        }
    }
}

