/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.util.containers.IntArrayList;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class ByteTrie {
    private static final String EMPTY_STRING = "";
    private static final String UTF_8_CHARSET_NAME = "UTF-8";
    private final ArrayList<Node> myAllNodes = new ArrayList();

    public ByteTrie() {
        Node root = new Node(-1, 0);
        this.myAllNodes.add(root);
    }

    public int size() {
        return this.myAllNodes.size();
    }

    public int getHashCode(String s) {
        try {
            return this.getHashCode(s.getBytes(UTF_8_CHARSET_NAME));
        }
        catch (UnsupportedEncodingException e) {
            return -1;
        }
    }

    public String getString(int hashCode) {
        try {
            return new String(this.getBytes(hashCode), UTF_8_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            return EMPTY_STRING;
        }
    }

    public int getHashCodeForReversedString(String s) {
        try {
            return this.getHashCodeForReversedBytes(s.getBytes(UTF_8_CHARSET_NAME));
        }
        catch (UnsupportedEncodingException e) {
            return -1;
        }
    }

    public String getReversedString(int hashCode) {
        try {
            return new String(this.getReversedBytes(hashCode), UTF_8_CHARSET_NAME);
        }
        catch (UnsupportedEncodingException e) {
            return EMPTY_STRING;
        }
    }

    public int getHashCode(byte[] bytes) {
        return this.getHashCode(bytes, 0, bytes.length);
    }

    public int getHashCode(byte[] bytes, int offset, int length) {
        int index = 0;
        while (length-- > 0) {
            index = this.getSubNode(index, bytes[offset++]);
        }
        return index;
    }

    public long getMaximumMatch(byte[] bytes, int offset, int length) {
        int nextIndex;
        int index = 0;
        int resultingLength = 0;
        while (length-- > 0 && (nextIndex = this.searchForSubNode(index, bytes[offset++])) != 0) {
            index = nextIndex;
            ++resultingLength;
        }
        return (long)index + ((long)resultingLength << 32);
    }

    public byte[] getBytes(int hashCode) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        while (hashCode > 0) {
            Node node = this.myAllNodes.get(hashCode);
            this.writeByte(stream, node.myChar);
            hashCode = node.myParent;
        }
        byte[] bytes = stream.toByteArray();
        int i = 0;
        for (int j = bytes.length - 1; i < j; ++i, --j) {
            byte swap = bytes[i];
            bytes[i] = bytes[j];
            bytes[j] = swap;
        }
        return bytes;
    }

    public int getHashCodeForReversedBytes(byte[] bytes) {
        return this.getHashCodeForReversedBytes(bytes, bytes.length - 1, bytes.length);
    }

    public int getHashCodeForReversedBytes(byte[] bytes, int offset, int length) {
        int index = 0;
        while (length-- > 0) {
            index = this.getSubNode(index, bytes[offset--]);
        }
        return index;
    }

    public byte[] getReversedBytes(int hashCode) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        while (hashCode > 0) {
            Node node = this.myAllNodes.get(hashCode);
            this.writeByte(stream, node.myChar);
            hashCode = node.myParent;
        }
        return stream.toByteArray();
    }

    private int getSubNode(int parentIndex, byte b) {
        int index;
        Node parentNode = this.myAllNodes.get(parentIndex);
        if (parentNode.myChildren == null) {
            parentNode.myChildren = new IntArrayList(1);
        }
        IntArrayList children = parentNode.myChildren;
        int left = 0;
        int right = children.size() - 1;
        while (left <= right) {
            int middle = left + right >> 1;
            index = children.get(middle);
            Node node = this.myAllNodes.get(index);
            int comp = node.myChar - b;
            if (comp == 0) {
                return index;
            }
            if (comp < 0) {
                left = middle + 1;
                continue;
            }
            right = middle - 1;
        }
        index = this.myAllNodes.size();
        children.add(left, index);
        this.myAllNodes.add(new Node(parentIndex, b));
        return index;
    }

    private int searchForSubNode(int parentIndex, byte b) {
        Node parentNode = this.myAllNodes.get(parentIndex);
        IntArrayList children = parentNode.myChildren;
        if (children == null) {
            return 0;
        }
        int left = 0;
        int right = children.size() - 1;
        while (left <= right) {
            int middle = left + right >> 1;
            int index = children.get(middle);
            Node node = this.myAllNodes.get(index);
            int comp = node.myChar - b;
            if (comp == 0) {
                return index;
            }
            if (comp < 0) {
                left = middle + 1;
                continue;
            }
            right = middle - 1;
        }
        return 0;
    }

    void writeByte(ByteArrayOutputStream stream, byte b) {
        int out = b;
        if (out < 0) {
            out += 256;
        }
        stream.write(out);
    }

    private static class Node {
        private final byte myChar;
        private final int myParent;
        private IntArrayList myChildren;

        Node(int parent, byte b) {
            this.myChar = b;
            this.myParent = parent;
        }
    }
}

