/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Field;
import sun.misc.Unsafe;

public class AtomicFieldUpdater<T, V> {
    private static final Unsafe unsafe = AtomicFieldUpdater.getUnsafe();
    private final long offset;

    public static Unsafe getUnsafe() {
        Unsafe unsafe = ReflectionUtil.getField(Unsafe.class, null, Unsafe.class, "theUnsafe");
        if (unsafe == null) {
            throw new RuntimeException("Could not find 'theUnsafe' field in the " + Unsafe.class);
        }
        return unsafe;
    }

    public static <T, V> AtomicFieldUpdater<T, V> forFieldOfType(Class<T> ownerClass, Class<V> fieldType) {
        return new AtomicFieldUpdater<T, V>(ownerClass, fieldType);
    }

    public static <T> AtomicFieldUpdater<T, Long> forLongFieldIn(Class<T> ownerClass) {
        return new AtomicFieldUpdater<T, Long>(ownerClass, Long.TYPE);
    }

    public static <T> AtomicFieldUpdater<T, Integer> forIntFieldIn(Class<T> ownerClass) {
        return new AtomicFieldUpdater<T, Integer>(ownerClass, Integer.TYPE);
    }

    private AtomicFieldUpdater(Class<T> ownerClass, Class<V> fieldType) {
        Field found = AtomicFieldUpdater.getTheOnlyVolatileFieldOfClass(ownerClass, fieldType);
        this.offset = unsafe.objectFieldOffset(found);
    }

    private static <T, V> Field getTheOnlyVolatileFieldOfClass(Class<T> ownerClass, Class<V> fieldType) {
        Field[] declaredFields = ownerClass.getDeclaredFields();
        Field found = null;
        for (Field field : declaredFields) {
            if ((field.getModifiers() & 0x18) != 0 || !fieldType.isAssignableFrom(field.getType())) continue;
            if (found == null) {
                found = field;
                continue;
            }
            throw new IllegalArgumentException("Two fields of " + fieldType + " found in the " + ownerClass + ": " + found.getName() + " and " + field.getName());
        }
        if (found == null) {
            throw new IllegalArgumentException("No (non-static, non-final) field of " + fieldType + " found in the " + ownerClass);
        }
        found.setAccessible(true);
        if ((found.getModifiers() & 0x40) == 0) {
            throw new IllegalArgumentException("Field " + found + " in the " + ownerClass + " must be volatile");
        }
        return found;
    }

    public boolean compareAndSet(T owner, V expected, V newValue) {
        return unsafe.compareAndSwapObject(owner, this.offset, expected, newValue);
    }

    public boolean compareAndSetLong(T owner, long expected, long newValue) {
        return unsafe.compareAndSwapLong(owner, this.offset, expected, newValue);
    }

    public boolean compareAndSetInt(T owner, int expected, int newValue) {
        return unsafe.compareAndSwapInt(owner, this.offset, expected, newValue);
    }

    public void set(T owner, V newValue) {
        unsafe.putObjectVolatile(owner, this.offset, newValue);
    }

    public V get(T owner) {
        return (V)unsafe.getObjectVolatile(owner, this.offset);
    }
}

