/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SingletonIterator;
import gnu.trove.TObjectHashingStrategy;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class SingletonSet<E>
implements Set<E> {
    private final E theElement;
    private final TObjectHashingStrategy<E> strategy;

    public SingletonSet(E e) {
        this(e, ContainerUtil.canonicalStrategy());
    }

    public SingletonSet(E e, TObjectHashingStrategy<E> strategy) {
        this.theElement = e;
        this.strategy = strategy;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public boolean contains(Object elem) {
        return this.strategy.equals(this.theElement, elem);
    }

    @Override
    public Iterator<E> iterator() {
        return new SingletonIterator<E>(this.theElement);
    }

    @Override
    public Object[] toArray() {
        return new Object[]{this.theElement};
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length == 0) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), 1);
        }
        a[0] = this.theElement;
        if (a.length > 1) {
            a[1] = null;
        }
        return a;
    }

    @Override
    public boolean add(E t) {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new IncorrectOperationException();
    }

    @Override
    public void clear() {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean isEmpty() {
        return false;
    }
}

