/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.HashMap;
import java.awt.Color;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.jdom.Element;
import org.jetbrains.annotations.PropertyKey;

public class Registry {
    private static Reference<ResourceBundle> ourBundle;
    public static final String REGISTRY_BUNDLE = "misc.registry";
    private final Map<String, String> myUserProperties = new LinkedHashMap<String, String>();
    private final Map<String, RegistryValue> myValues = new ConcurrentHashMap<String, RegistryValue>();
    private static final Registry ourInstance;

    public static RegistryValue get(@PropertyKey(resourceBundle="misc.registry") String key) {
        Registry registry = Registry.getInstance();
        RegistryValue value = registry.myValues.get(key);
        if (value == null) {
            value = new RegistryValue(registry, key);
            registry.myValues.put(key, value);
        }
        return value;
    }

    public static boolean is(@PropertyKey(resourceBundle="misc.registry") String key) throws MissingResourceException {
        return Registry.get(key).asBoolean();
    }

    public static boolean is(@PropertyKey(resourceBundle="misc.registry") String key, boolean defaultValue) {
        try {
            return Registry.get(key).asBoolean();
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    public static int intValue(@PropertyKey(resourceBundle="misc.registry") String key) throws MissingResourceException {
        return Registry.get(key).asInteger();
    }

    public static int intValue(@PropertyKey(resourceBundle="misc.registry") String key, int defaultValue) {
        try {
            return Registry.get(key).asInteger();
        }
        catch (MissingResourceException ex) {
            return defaultValue;
        }
    }

    public static double doubleValue(@PropertyKey(resourceBundle="misc.registry") String key) throws MissingResourceException {
        return Registry.get(key).asDouble();
    }

    public static String stringValue(@PropertyKey(resourceBundle="misc.registry") String key) throws MissingResourceException {
        return Registry.get(key).asString();
    }

    public static Color getColor(@PropertyKey(resourceBundle="misc.registry") String key, Color defaultValue) throws MissingResourceException {
        return Registry.get(key).asColor(defaultValue);
    }

    static ResourceBundle getBundle() {
        ResourceBundle bundle = SoftReference.dereference(ourBundle);
        if (bundle == null) {
            bundle = ResourceBundle.getBundle(REGISTRY_BUNDLE);
            ourBundle = new java.lang.ref.SoftReference<ResourceBundle>(bundle);
        }
        return bundle;
    }

    public static Registry getInstance() {
        return ourInstance;
    }

    public Element getState() {
        Element state = new Element("registry");
        for (String eachKey : this.myUserProperties.keySet()) {
            Element entry = new Element("entry");
            entry.setAttribute("key", eachKey);
            entry.setAttribute("value", this.myUserProperties.get(eachKey));
            state.addContent(entry);
        }
        return state;
    }

    public void loadState(Element state) {
        this.myUserProperties.clear();
        for (Element eachEntry : state.getChildren("entry")) {
            RegistryValue registryValue;
            String key = eachEntry.getAttributeValue("key");
            String value = eachEntry.getAttributeValue("value");
            if (key == null || value == null || !(registryValue = Registry.get(key)).isChangedFromDefault(value)) continue;
            this.myUserProperties.put(key, value);
            registryValue.resetCache();
        }
    }

    Map<String, String> getUserProperties() {
        return this.myUserProperties;
    }

    public static List<RegistryValue> getAll() {
        ResourceBundle bundle = Registry.getBundle();
        Enumeration<String> keys = bundle.getKeys();
        ArrayList<RegistryValue> result = new ArrayList<RegistryValue>();
        while (keys.hasMoreElements()) {
            String each = keys.nextElement();
            if (each.endsWith(".description") || each.endsWith(".restartRequired")) continue;
            result.add(Registry.get(each));
        }
        return result;
    }

    public void restoreDefaults() {
        HashMap<String, String> old = new HashMap<String, String>();
        old.putAll(this.myUserProperties);
        for (String each : old.keySet()) {
            Registry.get(each).resetToDefault();
        }
    }

    public boolean isInDefaultState() {
        return this.myUserProperties.isEmpty();
    }

    public boolean isRestartNeeded() {
        return Registry.isRestartNeeded(this.myUserProperties);
    }

    private static boolean isRestartNeeded(Map<String, String> map) {
        for (String s : map.keySet()) {
            RegistryValue eachValue = Registry.get(s);
            if (!eachValue.isRestartRequired() || !eachValue.isChangedSinceAppStart()) continue;
            return true;
        }
        return false;
    }

    static {
        ourInstance = new Registry();
    }
}

