/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SystemInfo
extends SystemInfoRt {
    public static final String OS_NAME = SystemInfoRt.OS_NAME;
    public static final String OS_VERSION = SystemInfoRt.OS_VERSION;
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final String JAVA_VERSION = System.getProperty("java.version");
    public static final String JAVA_RUNTIME_VERSION = System.getProperty("java.runtime.version");
    public static final String ARCH_DATA_MODEL = System.getProperty("sun.arch.data.model");
    public static final String SUN_DESKTOP = System.getProperty("sun.desktop", "");
    public static final boolean isWindows = SystemInfoRt.isWindows;
    public static final boolean isMac = SystemInfoRt.isMac;
    public static final boolean isOS2 = SystemInfoRt.isOS2;
    public static final boolean isLinux = SystemInfoRt.isLinux;
    public static final boolean isFreeBSD = SystemInfoRt.isFreeBSD;
    public static final boolean isSolaris = SystemInfoRt.isSolaris;
    public static final boolean isUnix = SystemInfoRt.isUnix;
    public static final boolean isAppleJvm = SystemInfo.isAppleJvm();
    public static final boolean isOracleJvm = SystemInfo.isOracleJvm();
    public static final boolean isSunJvm = SystemInfo.isSunJvm();
    public static final boolean isJetbrainsJvm = SystemInfo.isJetbrainsJvm();
    public static final boolean isWin2kOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("5.0");
    public static final boolean isWinVistaOrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.0");
    public static final boolean isWin7OrNewer = isWindows && SystemInfo.isOsVersionAtLeast("6.1");
    public static final boolean isWindowsXP = isWindows && (OS_VERSION.equals("5.1") || OS_VERSION.equals("5.2"));
    public static final boolean isXWindow = isUnix && !isMac;
    private static NotNullLazyValue<Map<String, String>> ourOsReleaseInfo = new AtomicNotNullLazyValue<Map<String, String>>(){

        @Override
        protected Map<String, String> compute() {
            if (isUnix && !isMac) {
                try {
                    List<String> lines = FileUtil.loadLines("/etc/os-release");
                    HashMap<String, String> info = ContainerUtil.newHashMap();
                    for (String line : lines) {
                        int p = line.indexOf(61);
                        if (p <= 0) continue;
                        String name = line.substring(0, p);
                        String value = StringUtil.unquoteString(line.substring(p + 1));
                        if (StringUtil.isEmptyOrSpaces(name) || StringUtil.isEmptyOrSpaces(value)) continue;
                        info.put(name, value);
                    }
                    return info;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return Collections.emptyMap();
        }
    };
    public static final boolean isMacSystemMenu = isMac && "true".equals(System.getProperty("apple.laf.useScreenMenuBar"));
    public static final boolean isFileSystemCaseSensitive = SystemInfoRt.isFileSystemCaseSensitive;
    public static final boolean areSymLinksSupported = isUnix || isWinVistaOrNewer;
    public static final boolean is32Bit = ARCH_DATA_MODEL == null || ARCH_DATA_MODEL.equals("32");
    public static final boolean is64Bit = !is32Bit;
    public static final boolean isAMD64 = "amd64".equals(OS_ARCH);
    public static final boolean isMacIntel64 = isMac && "x86_64".equals(OS_ARCH);
    private static final NotNullLazyValue<Boolean> ourHasXdgOpen = new AtomicNotNullLazyValue<Boolean>(){

        @Override
        protected Boolean compute() {
            return isUnix && new File("/usr/bin/xdg-open").canExecute();
        }
    };
    private static final NotNullLazyValue<Boolean> ourHasXdgMime = new AtomicNotNullLazyValue<Boolean>(){

        @Override
        protected Boolean compute() {
            return isUnix && new File("/usr/bin/xdg-mime").canExecute();
        }
    };
    public static final boolean isIntelMac = isMac && "i386".equals(OS_ARCH);
    public static final boolean isMacOSTiger = isMac && SystemInfo.isOsVersionAtLeast("10.4");
    public static final boolean isMacOSLeopard = isMac && SystemInfo.isOsVersionAtLeast("10.5");
    public static final boolean isMacOSSnowLeopard = isMac && SystemInfo.isOsVersionAtLeast("10.6");
    public static final boolean isMacOSLion = isMac && SystemInfo.isOsVersionAtLeast("10.7");
    public static final boolean isMacOSMountainLion = isMac && SystemInfo.isOsVersionAtLeast("10.8");
    public static final boolean isMacOSMavericks = isMac && SystemInfo.isOsVersionAtLeast("10.9");
    public static final boolean isMacOSYosemite = isMac && SystemInfo.isOsVersionAtLeast("10.10");

    public static boolean isOsVersionAtLeast(String version) {
        return StringUtil.compareVersionNumbers(OS_VERSION, version) >= 0;
    }

    public static String getUnixReleaseName() {
        return ourOsReleaseInfo.getValue().get("NAME");
    }

    public static String getUnixReleaseVersion() {
        return ourOsReleaseInfo.getValue().get("VERSION");
    }

    public static boolean hasXdgOpen() {
        return ourHasXdgOpen.getValue();
    }

    public static boolean hasXdgMime() {
        return ourHasXdgOpen.getValue();
    }

    public static String getMacOSMajorVersion() {
        return SystemInfo.getMacOSMajorVersion(OS_VERSION);
    }

    public static String getMacOSMajorVersion(String version) {
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        return String.format("%d.%d", parts[0], parts[1]);
    }

    public static String getMacOSVersionCode() {
        return SystemInfo.getMacOSVersionCode(OS_VERSION);
    }

    public static String getMacOSMajorVersionCode() {
        return SystemInfo.getMacOSMajorVersionCode(OS_VERSION);
    }

    public static String getMacOSMinorVersionCode() {
        return SystemInfo.getMacOSMinorVersionCode(OS_VERSION);
    }

    public static String getMacOSVersionCode(String version) {
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        return String.format("%02d%d%d", parts[0], SystemInfo.normalize(parts[1]), SystemInfo.normalize(parts[2]));
    }

    public static String getMacOSMajorVersionCode(String version) {
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        return String.format("%02d%d%d", parts[0], SystemInfo.normalize(parts[1]), 0);
    }

    public static String getMacOSMinorVersionCode(String version) {
        int[] parts = SystemInfo.getMacOSVersionParts(version);
        return String.format("%02d%02d", parts[1], parts[2]);
    }

    private static int[] getMacOSVersionParts(String version) {
        List<String> parts = StringUtil.split(version, ".");
        while (parts.size() < 3) {
            parts.add("0");
        }
        return new int[]{SystemInfo.toInt(parts.get(0)), SystemInfo.toInt(parts.get(1)), SystemInfo.toInt(parts.get(2))};
    }

    private static int normalize(int number) {
        return number > 9 ? 9 : number;
    }

    private static int toInt(String string) {
        try {
            return Integer.valueOf(string);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static boolean isJavaVersionAtLeast(String v) {
        return StringUtil.compareVersionNumbers(JAVA_RUNTIME_VERSION, v) >= 0;
    }

    private static boolean isOracleJvm() {
        String vendor = SystemProperties.getJavaVmVendor();
        return vendor != null && StringUtil.containsIgnoreCase(vendor, "Oracle");
    }

    private static boolean isSunJvm() {
        String vendor = SystemProperties.getJavaVmVendor();
        return vendor != null && StringUtil.containsIgnoreCase(vendor, "Sun") && StringUtil.containsIgnoreCase(vendor, "Microsystems");
    }

    private static boolean isAppleJvm() {
        String vendor = SystemProperties.getJavaVmVendor();
        return vendor != null && StringUtil.containsIgnoreCase(vendor, "Apple");
    }

    private static boolean isJetbrainsJvm() {
        String vendor = SystemProperties.getJavaVendor();
        return vendor != null && StringUtil.containsIgnoreCase(vendor, "jetbrains");
    }
}

