/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;

public class NullableLazyKey<T, H extends UserDataHolder>
extends Key<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("NullableLazyKey");
    private final NullableFunction<H, T> myFunction;

    private NullableLazyKey(String name, NullableFunction<H, T> function) {
        super(name);
        this.myFunction = function;
    }

    public final T getValue(H h) {
        Object data = h.getUserData(this);
        if (data == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            data = this.myFunction.fun(h);
            if (stamp.mayCacheNow()) {
                h.putUserData(this, (Object)(data == null ? ObjectUtils.NULL : data));
            }
        }
        return data == ObjectUtils.NULL ? null : (T)data;
    }

    public static <T, H extends UserDataHolder> NullableLazyKey<T, H> create(String name, NullableFunction<H, T> function) {
        return new NullableLazyKey<T, H>(name, function);
    }
}

