/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class Key<T> {
    private static final AtomicInteger ourKeysCounter = new AtomicInteger();
    private final int myIndex = ourKeysCounter.getAndIncrement();
    private final String myName;
    private static final ConcurrentIntObjectMap<Key> allKeys = ContainerUtil.createConcurrentIntObjectWeakValueMap();

    public Key(String name) {
        this.myName = name;
        allKeys.put(this.myIndex, this);
    }

    public final int hashCode() {
        return this.myIndex;
    }

    public final boolean equals(Object obj) {
        return obj == this;
    }

    public String toString() {
        return this.myName;
    }

    public static <T> Key<T> create(String name) {
        return new Key<T>(name);
    }

    public T get(UserDataHolder holder) {
        return holder == null ? null : (T)holder.getUserData(this);
    }

    public T get(Map<Key, ?> holder) {
        return holder == null ? null : (T)holder.get(this);
    }

    public T get(UserDataHolder holder, T defaultValue) {
        T t = this.get(holder);
        return t == null ? defaultValue : t;
    }

    public boolean isIn(UserDataHolder holder) {
        return this.get(holder) != null;
    }

    public void set(UserDataHolder holder, T value) {
        if (holder != null) {
            holder.putUserData(this, value);
        }
    }

    public void set(Map<Key, Object> holder, T value) {
        if (holder != null) {
            holder.put(this, value);
        }
    }

    public static <T> Key<T> getKeyByIndex(int index) {
        return allKeys.get(index);
    }

    public static Key<?> findKeyByName(String name) {
        for (ConcurrentIntObjectMap.IntEntry<Key> key : allKeys.entries()) {
            if (!name.equals(key.getValue().myName)) continue;
            return key.getValue();
        }
        return null;
    }
}

