/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.reference.SoftReference;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.ImageLoader;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.RetinaImage;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakHashMap;
import com.intellij.util.ui.JBImageIcon;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;

public final class IconLoader {
    private static final Logger LOG = Logger.getInstance("#com.intellij.openapi.util.IconLoader");
    public static boolean STRICT = false;
    private static boolean USE_DARK_ICONS = UIUtil.isUnderDarcula();
    private static float SCALE = JBUI.scale(1.0f);
    private static final ConcurrentMap<URL, CachedImageIcon> ourIconsCache = ContainerUtil.newConcurrentMap(100, 0.9f, 2);
    private static final Map<Icon, Icon> ourIcon2DisabledIcon = new WeakHashMap<Icon, Icon>(200);
    private static final Map<String, String> ourDeprecatedIconsReplacements = new HashMap<String, String>();
    private static final ImageIcon EMPTY_ICON;
    private static boolean ourIsActivated;

    private IconLoader() {
    }

    @Deprecated
    public static Icon getIcon(Image image) {
        return new JBImageIcon(image);
    }

    public static void setUseDarkIcons(boolean useDarkIcons) {
        USE_DARK_ICONS = useDarkIcons;
        IconLoader.clearCache();
    }

    public static void setScale(float scale) {
        if (scale != SCALE) {
            SCALE = scale;
            IconLoader.clearCache();
        }
    }

    private static void clearCache() {
        ourIconsCache.clear();
        ourIcon2DisabledIcon.clear();
    }

    public static Icon getIcon(String path) {
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        assert (callerClass != null) : path;
        return IconLoader.getIcon(path, callerClass);
    }

    private static Icon getReflectiveIcon(String path, ClassLoader classLoader) {
        try {
            String pckg = path.startsWith("AllIcons.") ? "com.intellij.icons." : "icons.";
            Class<?> cur = Class.forName(pckg + path.substring(0, path.lastIndexOf(46)).replace('.', '$'), true, classLoader);
            Field field = cur.getField(path.substring(path.lastIndexOf(46) + 1));
            return (Icon)field.get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Icon findIcon(String path) {
        Class callerClass = ReflectionUtil.getGrandCallerClass();
        if (callerClass == null) {
            return null;
        }
        return IconLoader.findIcon(path, callerClass);
    }

    public static Icon getIcon(String path, Class aClass) {
        Icon icon = IconLoader.findIcon(path, aClass);
        if (icon == null) {
            LOG.error("Icon cannot be found in '" + path + "', aClass='" + aClass + "'");
        }
        return icon;
    }

    public static void activate() {
        ourIsActivated = true;
    }

    private static boolean isLoaderDisabled() {
        return !ourIsActivated;
    }

    public static Icon findIcon(String path, Class aClass) {
        return IconLoader.findIcon(path, aClass, false);
    }

    public static Icon findIcon(String path, Class aClass, boolean computeNow) {
        if (IconLoader.isReflectivePath(path = IconLoader.undeprecate(path))) {
            return IconLoader.getReflectiveIcon(path, aClass.getClassLoader());
        }
        URL myURL = aClass.getResource(path);
        if (myURL == null) {
            if (STRICT) {
                throw new RuntimeException("Can't find icon in '" + path + "' near " + aClass);
            }
            return null;
        }
        return IconLoader.findIcon(myURL);
    }

    private static String undeprecate(String path) {
        String replacement = ourDeprecatedIconsReplacements.get(path);
        return replacement == null ? path : replacement;
    }

    private static boolean isReflectivePath(String path) {
        List<String> paths = StringUtil.split(path, ".");
        return paths.size() > 1 && paths.get(0).endsWith("Icons");
    }

    public static Icon findIcon(URL url) {
        return IconLoader.findIcon(url, true);
    }

    public static Icon findIcon(URL url, boolean useCache) {
        if (url == null) {
            return null;
        }
        CachedImageIcon icon = (CachedImageIcon)ourIconsCache.get(url);
        if (icon == null) {
            icon = new CachedImageIcon(url);
            if (useCache) {
                icon = ConcurrencyUtil.cacheOrGet(ourIconsCache, url, icon);
            }
        }
        return icon;
    }

    public static Icon findIcon(String path, ClassLoader classLoader) {
        if (IconLoader.isReflectivePath(path = IconLoader.undeprecate(path))) {
            return IconLoader.getReflectiveIcon(path, classLoader);
        }
        if (!StringUtil.startsWithChar(path, '/')) {
            return null;
        }
        URL url = classLoader.getResource(path.substring(1));
        return IconLoader.findIcon(url);
    }

    private static Icon checkIcon(Image image, URL url) {
        if (image == null || image.getHeight(LabelHolder.ourFakeComponent) < 1) {
            return null;
        }
        Icon icon = IconLoader.getIcon(image);
        if (icon != null && !IconLoader.isGoodSize(icon)) {
            LOG.error("Invalid icon: " + url);
            return EMPTY_ICON;
        }
        return icon;
    }

    public static boolean isGoodSize(Icon icon) {
        return icon.getIconWidth() > 0 && icon.getIconHeight() > 0;
    }

    public static Icon getDisabledIcon(Icon icon) {
        if (icon instanceof LazyIcon) {
            icon = ((LazyIcon)icon).getOrComputeIcon();
        }
        if (icon == null) {
            return null;
        }
        Icon disabledIcon = ourIcon2DisabledIcon.get(icon);
        if (disabledIcon == null) {
            if (!IconLoader.isGoodSize(icon)) {
                return EMPTY_ICON;
            }
            int scale = UIUtil.isRetina() ? 2 : 1;
            BufferedImage image = new BufferedImage(scale * icon.getIconWidth(), scale * icon.getIconHeight(), 2);
            Graphics2D graphics = image.createGraphics();
            graphics.setColor(UIUtil.TRANSPARENT_COLOR);
            graphics.fillRect(0, 0, icon.getIconWidth(), icon.getIconHeight());
            graphics.scale(scale, scale);
            icon.paintIcon(LabelHolder.ourFakeComponent, graphics, 0, 0);
            graphics.dispose();
            Image img = IconLoader.createDisabled(image);
            if (UIUtil.isRetina()) {
                img = RetinaImage.createFrom(img, 2, ImageLoader.ourComponent);
            }
            disabledIcon = new JBImageIcon(img);
            ourIcon2DisabledIcon.put(icon, disabledIcon);
        }
        return disabledIcon;
    }

    private static Image createDisabled(BufferedImage image) {
        GrayFilter filter = UIUtil.getGrayFilter();
        FilteredImageSource prod = new FilteredImageSource(image.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(prod);
    }

    public static Icon getTransparentIcon(Icon icon) {
        return IconLoader.getTransparentIcon(icon, 0.5f);
    }

    public static Icon getTransparentIcon(final Icon icon, final float alpha) {
        return new Icon(){

            @Override
            public int getIconHeight() {
                return icon.getIconHeight();
            }

            @Override
            public int getIconWidth() {
                return icon.getIconWidth();
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g;
                Composite saveComposite = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(10, alpha));
                icon.paintIcon(c, g2, x, y);
                g2.setComposite(saveComposite);
            }
        };
    }

    static {
        ourDeprecatedIconsReplacements.put("/general/toolWindowDebugger.png", "AllIcons.Toolwindows.ToolWindowDebugger");
        ourDeprecatedIconsReplacements.put("/general/toolWindowChanges.png", "AllIcons.Toolwindows.ToolWindowChanges");
        ourDeprecatedIconsReplacements.put("/actions/showSettings.png", "AllIcons.General.ProjectSettings");
        ourDeprecatedIconsReplacements.put("/general/ideOptions.png", "AllIcons.General.Settings");
        ourDeprecatedIconsReplacements.put("/general/applicationSettings.png", "AllIcons.General.Settings");
        ourDeprecatedIconsReplacements.put("/toolbarDecorator/add.png", "AllIcons.General.Add");
        ourDeprecatedIconsReplacements.put("/vcs/customizeView.png", "AllIcons.General.Settings");
        ourDeprecatedIconsReplacements.put("/vcs/refresh.png", "AllIcons.Actions.Refresh");
        ourDeprecatedIconsReplacements.put("/actions/sync.png", "AllIcons.Actions.Refresh");
        ourDeprecatedIconsReplacements.put("/actions/refreshUsages.png", "AllIcons.Actions.Rerun");
        ourDeprecatedIconsReplacements.put("/compiler/error.png", "AllIcons.General.Error");
        ourDeprecatedIconsReplacements.put("/compiler/hideWarnings.png", "AllIcons.General.HideWarnings");
        ourDeprecatedIconsReplacements.put("/compiler/information.png", "AllIcons.General.Information");
        ourDeprecatedIconsReplacements.put("/compiler/warning.png", "AllIcons.General.Warning");
        ourDeprecatedIconsReplacements.put("/ide/errorSign.png", "AllIcons.General.Error");
        ourDeprecatedIconsReplacements.put("/ant/filter.png", "AllIcons.General.Filter");
        ourDeprecatedIconsReplacements.put("/inspector/useFilter.png", "AllIcons.General.Filter");
        ourDeprecatedIconsReplacements.put("/actions/showSource.png", "AllIcons.Actions.Preview");
        ourDeprecatedIconsReplacements.put("/actions/consoleHistory.png", "AllIcons.General.MessageHistory");
        ourDeprecatedIconsReplacements.put("/vcs/messageHistory.png", "AllIcons.General.MessageHistory");
        EMPTY_ICON = new ImageIcon(UIUtil.createImage(1, 1, 5)){

            @Override
            public String toString() {
                return "Empty icon " + super.toString();
            }
        };
        ourIsActivated = false;
    }

    private static class LabelHolder {
        private static final JComponent ourFakeComponent = new JLabel();

        private LabelHolder() {
        }
    }

    public static abstract class LazyIcon
    implements Icon {
        private boolean myWasComputed;
        private Icon myIcon;
        private boolean isDarkVariant = IconLoader.access$100();
        private float scale = IconLoader.access$200();

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Icon icon = this.getOrComputeIcon();
            if (icon != null) {
                icon.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            Icon icon = this.getOrComputeIcon();
            return icon != null ? icon.getIconWidth() : 0;
        }

        @Override
        public int getIconHeight() {
            Icon icon = this.getOrComputeIcon();
            return icon != null ? icon.getIconHeight() : 0;
        }

        protected final synchronized Icon getOrComputeIcon() {
            if (!this.myWasComputed || this.isDarkVariant != USE_DARK_ICONS || this.scale != SCALE) {
                this.isDarkVariant = USE_DARK_ICONS;
                this.scale = SCALE;
                this.myWasComputed = true;
                this.myIcon = this.compute();
            }
            return this.myIcon;
        }

        public final void load() {
            this.getIconWidth();
        }

        protected abstract Icon compute();
    }

    private static final class CachedImageIcon
    implements Icon {
        private Object myRealIcon;
        private final URL myUrl;
        private boolean dark;
        private float scale;

        public CachedImageIcon(URL url) {
            this.myUrl = url;
            this.dark = USE_DARK_ICONS;
            this.scale = SCALE;
        }

        private synchronized Icon getRealIcon() {
            Icon icon;
            Object realIcon;
            if (IconLoader.isLoaderDisabled() && (this.myRealIcon == null || this.dark != USE_DARK_ICONS || this.scale != SCALE)) {
                return EMPTY_ICON;
            }
            if (this.dark != USE_DARK_ICONS || this.scale != SCALE) {
                this.myRealIcon = null;
                this.dark = USE_DARK_ICONS;
                this.scale = SCALE;
            }
            if ((realIcon = this.myRealIcon) instanceof Icon) {
                return (Icon)realIcon;
            }
            if (realIcon instanceof Reference && (icon = (Icon)((Reference)realIcon).get()) != null) {
                return icon;
            }
            Image image = ImageLoader.loadFromUrl(this.myUrl);
            icon = IconLoader.checkIcon(image, this.myUrl);
            if (icon != null) {
                realIcon = icon.getIconWidth() < 50 && icon.getIconHeight() < 50 ? icon : new SoftReference<Icon>(icon);
                this.myRealIcon = realIcon;
            }
            return icon == null ? EMPTY_ICON : icon;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            this.getRealIcon().paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return this.getRealIcon().getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return this.getRealIcon().getIconHeight();
        }

        public String toString() {
            return this.myUrl.toString();
        }
    }
}

