/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.objectTree.ObjectTree;
import com.intellij.openapi.util.objectTree.ObjectTreeAction;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import java.lang.reflect.Field;
import java.util.Map;

public class Disposer {
    private static final ObjectTree<Disposable> ourTree;
    private static final ObjectTreeAction<Disposable> ourDisposeAction;
    private static boolean ourDebugMode;
    private static final Map<String, Disposable> ourKeyDisposables;

    private Disposer() {
    }

    public static Disposable newDisposable() {
        return new Disposable(){

            @Override
            public void dispose() {
            }
        };
    }

    public static void register(Disposable parent, Disposable child) {
        Disposer.register(parent, child, null);
    }

    public static void register(Disposable parent, Disposable child, final String key) {
        assert (parent != child) : " Cannot register to itself";
        ourTree.register(parent, child);
        if (key != null) {
            assert (Disposer.get(key) == null);
            ourKeyDisposables.put(key, child);
            Disposer.register(child, new Disposable(){

                @Override
                public void dispose() {
                    ourKeyDisposables.remove(key);
                }
            });
        }
    }

    public static boolean isDisposed(Disposable disposable) {
        return !ourTree.containsKey(disposable);
    }

    public static Disposable get(String key) {
        return ourKeyDisposables.get(key);
    }

    public static void dispose(Disposable disposable) {
        Disposer.dispose(disposable, true);
    }

    public static void dispose(Disposable disposable, boolean processUnregistered) {
        ourTree.executeAll(disposable, true, ourDisposeAction, processUnregistered);
    }

    public static void disposeChildAndReplace(Disposable toDispose, Disposable toReplace) {
        ourTree.executeChildAndReplace(toDispose, toReplace, true, ourDisposeAction);
    }

    public static ObjectTree<Disposable> getTree() {
        return ourTree;
    }

    public static void assertIsEmpty() {
        Disposer.assertIsEmpty(false);
    }

    public static void assertIsEmpty(boolean throwError) {
        if (ourDebugMode) {
            ourTree.assertIsEmpty(throwError);
        }
    }

    public static boolean isEmpty() {
        return ourDebugMode && ourTree.isEmpty();
    }

    public static void setDebugMode(boolean b) {
        ourDebugMode = b;
    }

    public static boolean isDebugMode() {
        return ourDebugMode;
    }

    public static void clearOwnFields(Object object) {
        Field[] all;
        for (Field each : all = object.getClass().getDeclaredFields()) {
            if ((each.getModifiers() & 0x18) > 0) continue;
            ReflectionUtil.resetField(object, each);
        }
    }

    public static <T extends Disposable> T findRegisteredObject(Disposable parentDisposable, T object) {
        return ourTree.findRegisteredObject(parentDisposable, object);
    }

    static {
        try {
            ourTree = new ObjectTree();
        }
        catch (NoClassDefFoundError e) {
            throw new RuntimeException("loader=" + Disposer.class.getClassLoader(), e);
        }
        ourDisposeAction = new ObjectTreeAction<Disposable>(){

            @Override
            public void execute(Disposable each) {
                each.dispose();
            }

            @Override
            public void beforeTreeExecution(Disposable parent) {
                if (parent instanceof Disposable.Parent) {
                    ((Disposable.Parent)parent).beforeTreeDispose();
                }
            }
        };
        ourKeyDisposables = ContainerUtil.createConcurrentWeakMap();
    }
}

