/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

public interface Computable<T> {
    public T compute();

    public static abstract class NullableCachedComputable<T>
    implements Computable<T> {
        private static final Object NULL_VALUE = new Object();
        private Object myValue;

        protected abstract T internalCompute();

        @Override
        public final T compute() {
            if (this.myValue == null) {
                T value = this.internalCompute();
                this.myValue = value != null ? value : NULL_VALUE;
            }
            return (T)(this.myValue != NULL_VALUE ? this.myValue : null);
        }
    }

    public static abstract class NotNullCachedComputable<T>
    implements Computable<T> {
        private T myValue;

        protected abstract T internalCompute();

        @Override
        public final T compute() {
            if (this.myValue == null) {
                this.myValue = this.internalCompute();
            }
            return this.myValue;
        }
    }

    public static class PredefinedValueComputable<T>
    implements Computable<T> {
        private final T myValue;

        public PredefinedValueComputable(T value) {
            this.myValue = value;
        }

        @Override
        public T compute() {
            return this.myValue;
        }
    }
}

