/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;

public abstract class ClearableLazyValue<T> {
    private static final RecursionGuard ourGuard = RecursionManager.createGuard("ClearableLazyValue");
    private T myValue;

    protected abstract T compute();

    public T getValue() {
        T result = this.myValue;
        if (result == null) {
            RecursionGuard.StackStamp stamp = ourGuard.markStack();
            result = this.compute();
            if (stamp.mayCacheNow()) {
                this.myValue = result;
            }
        }
        return result;
    }

    public void drop() {
        this.myValue = null;
    }
}

