/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class LoggerRt {
    private static Factory ourFactory;

    private static synchronized Factory getFactory() {
        if (ourFactory == null) {
            try {
                ourFactory = new IdeaFactory();
            }
            catch (Throwable t) {
                ourFactory = new JavaFactory();
            }
        }
        return ourFactory;
    }

    public static LoggerRt getInstance(String category) {
        return LoggerRt.getFactory().getInstance(category);
    }

    public void info(String message) {
        this.info(message, null);
    }

    public void info(Throwable t) {
        this.info(t.getMessage(), t);
    }

    public void warn(String message) {
        this.warn(message, null);
    }

    public void warn(Throwable t) {
        this.warn(t.getMessage(), t);
    }

    public void error(String message) {
        this.error(message, null);
    }

    public void error(Throwable t) {
        this.error(t.getMessage(), t);
    }

    public abstract void info(String var1, Throwable var2);

    public abstract void warn(String var1, Throwable var2);

    public abstract void error(String var1, Throwable var2);

    private static class IdeaFactory
    implements Factory {
        private final Method myGetInstance;
        private final Method myInfo;
        private final Method myWarn;
        private final Method myError;

        private IdeaFactory() throws Exception {
            Class<?> loggerClass = Class.forName("com.intellij.openapi.diagnostic.Logger");
            this.myGetInstance = loggerClass.getMethod("getInstance", String.class);
            this.myGetInstance.setAccessible(true);
            this.myInfo = loggerClass.getMethod("info", String.class, Throwable.class);
            this.myInfo.setAccessible(true);
            this.myWarn = loggerClass.getMethod("warn", String.class, Throwable.class);
            this.myInfo.setAccessible(true);
            this.myError = loggerClass.getMethod("error", String.class, Throwable.class);
            this.myError.setAccessible(true);
        }

        @Override
        public LoggerRt getInstance(String category) {
            try {
                final Object logger = this.myGetInstance.invoke(null, category);
                return new LoggerRt(){

                    @Override
                    public void info(String message, Throwable t) {
                        try {
                            IdeaFactory.this.myInfo.invoke(logger, message, t);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void warn(String message, Throwable t) {
                        try {
                            IdeaFactory.this.myWarn.invoke(logger, message, t);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }

                    @Override
                    public void error(String message, Throwable t) {
                        try {
                            IdeaFactory.this.myError.invoke(logger, message, t);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                };
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class JavaFactory
    implements Factory {
        private JavaFactory() {
        }

        @Override
        public LoggerRt getInstance(String category) {
            final Logger logger = Logger.getLogger(category);
            return new LoggerRt(){

                @Override
                public void info(String message, Throwable t) {
                    logger.log(Level.INFO, message, t);
                }

                @Override
                public void warn(String message, Throwable t) {
                    logger.log(Level.WARNING, message, t);
                }

                @Override
                public void error(String message, Throwable t) {
                    logger.log(Level.SEVERE, message, t);
                }
            };
        }
    }

    private static interface Factory {
        public LoggerRt getInstance(String var1);
    }
}

