/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diagnostic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ExceptionUtil;
import java.io.IOException;

public class LogUtil {
    private LogUtil() {
    }

    public static String objectAndClass(Object o) {
        return o != null ? o + " (" + o.getClass().getName() + ")" : "null";
    }

    public static void debug(Logger logger, String format, Object ... args) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format(format, args));
        }
    }

    public static String getProcessList() {
        try {
            String[] stringArray;
            ProcessBuilder processBuilder = new ProcessBuilder(new String[0]);
            if (SystemInfo.isWindows) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = System.getenv("windir") + "\\system32\\tasklist.exe";
                stringArray = stringArray2;
                stringArray2[1] = "/v";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "ps";
                stringArray = stringArray3;
                stringArray3[1] = "a";
            }
            Process process = processBuilder.command(stringArray).redirectErrorStream(true).start();
            return FileUtil.loadTextAndClose(process.getInputStream());
        }
        catch (IOException e) {
            return ExceptionUtil.getThrowableText(e);
        }
    }
}

