/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.Asn1Object;
import com.intellij.execution.rmi.ssl.DerParser;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.Base64;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PrivateKeyReader {
    public static final String P1_BEGIN_MARKER = "-----BEGIN RSA PRIVATE KEY";
    public static final String P1_END_MARKER = "-----END RSA PRIVATE KEY";
    public static final String P8_BEGIN_MARKER = "-----BEGIN PRIVATE KEY";
    public static final String P8_END_MARKER = "-----END PRIVATE KEY";
    private static Map<String, PrivateKey> keyCache = Collections.synchronizedMap(new HashMap());
    private final String myFileName;

    public PrivateKeyReader(String fileName) {
        this.myFileName = fileName;
    }

    public PrivateKey getPrivateKey() throws IOException {
        PrivateKey key = keyCache.get(this.myFileName);
        if (key != null) {
            return key;
        }
        key = PrivateKeyReader.read(this.myFileName);
        keyCache.put(this.myFileName, key);
        return key;
    }

    private static PrivateKey read(String fileName) throws IOException {
        KeyFactory factory;
        try {
            factory = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException("JCE error: " + e.getMessage());
        }
        List<String> lines = FileUtilRt.loadLines(fileName, "UTF-8");
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (line.contains(P1_BEGIN_MARKER)) {
                List<String> strings = lines.subList(i + 1, lines.size());
                byte[] keyBytes = PrivateKeyReader.readKeyMaterial(P1_END_MARKER, strings);
                RSAPrivateCrtKeySpec keySpec = PrivateKeyReader.getRSAKeySpec(keyBytes);
                try {
                    return factory.generatePrivate(keySpec);
                }
                catch (InvalidKeySpecException e) {
                    throw new IOException("Invalid PKCS#1 PEM file: " + e.getMessage());
                }
            }
            if (!line.contains(P8_BEGIN_MARKER)) continue;
            List<String> strings = lines.subList(i + 1, lines.size());
            byte[] keyBytes = PrivateKeyReader.readKeyMaterial(P8_END_MARKER, strings);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(keyBytes);
            try {
                return factory.generatePrivate(keySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new IOException("Invalid PKCS#8 PEM file: " + e.getMessage());
            }
        }
        throw new IOException("Invalid PEM file: no begin marker");
    }

    private static byte[] readKeyMaterial(String endMarker, List<String> strings) throws IOException {
        StringBuilder buf = new StringBuilder();
        for (String line : strings) {
            if (line.contains(endMarker)) {
                return Base64.decode(buf.toString());
            }
            buf.append(line.trim());
        }
        throw new IOException("Invalid PEM file: No end marker");
    }

    private static RSAPrivateCrtKeySpec getRSAKeySpec(byte[] keyBytes) throws IOException {
        DerParser parser = new DerParser(keyBytes);
        Asn1Object sequence = parser.read();
        if (sequence.getType() != 16) {
            throw new IOException("Invalid DER: not a sequence");
        }
        parser = sequence.getParser();
        parser.read();
        BigInteger modulus = parser.read().getInteger();
        BigInteger publicExp = parser.read().getInteger();
        BigInteger privateExp = parser.read().getInteger();
        BigInteger prime1 = parser.read().getInteger();
        BigInteger prime2 = parser.read().getInteger();
        BigInteger exp1 = parser.read().getInteger();
        BigInteger exp2 = parser.read().getInteger();
        BigInteger crtCoef = parser.read().getInteger();
        return new RSAPrivateCrtKeySpec(modulus, publicExp, privateExp, prime1, prime2, exp1, exp2, crtCoef);
    }
}

