/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ProcessHandler
extends UserDataHolderBase {
    private static final Logger LOG = Logger.getInstance("#com.intellij.execution.process.ProcessHandler");
    public static final Key<Boolean> SILENTLY_DESTROY_ON_CLOSE = Key.create("SILENTLY_DESTROY_ON_CLOSE");
    private final List<ProcessListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private static final int STATE_INITIAL = 0;
    private static final int STATE_RUNNING = 1;
    private static final int STATE_TERMINATING = 2;
    private static final int STATE_TERMINATED = 3;
    private final AtomicInteger myState = new AtomicInteger(0);
    private final Semaphore myWaitSemaphore;
    private final ProcessListener myEventMulticaster = this.createEventMulticaster();
    private final TasksRunner myAfterStartNotifiedRunner;

    protected ProcessHandler() {
        this.myWaitSemaphore = new Semaphore();
        this.myWaitSemaphore.down();
        this.myAfterStartNotifiedRunner = new TasksRunner();
        this.myListeners.add(this.myAfterStartNotifiedRunner);
    }

    public void startNotify() {
        if (this.myState.compareAndSet(0, 1)) {
            this.myEventMulticaster.startNotified(new ProcessEvent(this));
        } else {
            LOG.error("startNotify called already");
        }
    }

    protected abstract void destroyProcessImpl();

    protected abstract void detachProcessImpl();

    public abstract boolean detachIsDefault();

    public boolean waitFor() {
        try {
            this.myWaitSemaphore.waitFor();
            return true;
        }
        catch (ProcessCanceledException e) {
            return false;
        }
    }

    public boolean waitFor(long timeoutInMilliseconds) {
        try {
            return this.myWaitSemaphore.waitFor(timeoutInMilliseconds);
        }
        catch (ProcessCanceledException e) {
            return false;
        }
    }

    public void destroyProcess() {
        this.myAfterStartNotifiedRunner.execute(new Runnable(){

            @Override
            public void run() {
                if (ProcessHandler.this.myState.compareAndSet(1, 2)) {
                    ProcessHandler.this.fireProcessWillTerminate(true);
                    ProcessHandler.this.destroyProcessImpl();
                }
            }
        });
    }

    public void detachProcess() {
        this.myAfterStartNotifiedRunner.execute(new Runnable(){

            @Override
            public void run() {
                if (ProcessHandler.this.myState.compareAndSet(1, 2)) {
                    ProcessHandler.this.fireProcessWillTerminate(false);
                    ProcessHandler.this.detachProcessImpl();
                }
            }
        });
    }

    public boolean isProcessTerminated() {
        return this.myState.get() == 3;
    }

    public boolean isProcessTerminating() {
        return this.myState.get() == 2;
    }

    public void addProcessListener(ProcessListener listener) {
        this.myListeners.add(listener);
    }

    public void removeProcessListener(ProcessListener listener) {
        this.myListeners.remove(listener);
    }

    protected void notifyProcessDetached() {
        this.notifyTerminated(0, false);
    }

    protected void notifyProcessTerminated(int exitCode) {
        this.notifyTerminated(exitCode, true);
    }

    private void notifyTerminated(final int exitCode, final boolean willBeDestroyed) {
        this.myAfterStartNotifiedRunner.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block10: {
                    LOG.assertTrue(ProcessHandler.this.isStartNotified(), "Start notify is not called");
                    if (ProcessHandler.this.myState.compareAndSet(1, 2)) {
                        try {
                            ProcessHandler.this.fireProcessWillTerminate(willBeDestroyed);
                        }
                        catch (Throwable e) {
                            if (ProcessHandler.isCanceledException(e)) break block10;
                            LOG.error(e);
                        }
                    }
                }
                if (ProcessHandler.this.myState.compareAndSet(2, 3)) {
                    try {
                        ProcessHandler.this.myEventMulticaster.processTerminated(new ProcessEvent(ProcessHandler.this, exitCode));
                    }
                    catch (Throwable e) {
                        if (!ProcessHandler.isCanceledException(e)) {
                            LOG.error(e);
                        }
                    }
                    finally {
                        ProcessHandler.this.myWaitSemaphore.up();
                    }
                }
            }
        });
    }

    public void notifyTextAvailable(String text, Key outputType) {
        ProcessEvent event = new ProcessEvent(this, text);
        this.myEventMulticaster.onTextAvailable(event, outputType);
    }

    public abstract OutputStream getProcessInput();

    private void fireProcessWillTerminate(boolean willBeDestroyed) {
        LOG.assertTrue(this.isStartNotified(), "All events should be fired after startNotify is called");
        this.myEventMulticaster.processWillTerminate(new ProcessEvent(this), willBeDestroyed);
    }

    public boolean isStartNotified() {
        return this.myState.get() > 0;
    }

    public boolean isSilentlyDestroyOnClose() {
        return false;
    }

    private ProcessListener createEventMulticaster() {
        Class<ProcessListener> listenerClass = ProcessListener.class;
        return (ProcessListener)Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object object, Method method, Object[] params) throws Throwable {
                for (ProcessListener listener : ProcessHandler.this.myListeners) {
                    try {
                        method.invoke((Object)listener, params);
                    }
                    catch (Throwable e) {
                        if (ProcessHandler.isCanceledException(e)) continue;
                        LOG.error(e);
                    }
                }
                return null;
            }
        });
    }

    private static boolean isCanceledException(Throwable e) {
        boolean value;
        boolean bl = value = e instanceof InvocationTargetException && e.getCause() instanceof ProcessCanceledException;
        if (value) {
            LOG.info(e);
        }
        return value;
    }

    private final class TasksRunner
    extends ProcessAdapter {
        private final List<Runnable> myPendingTasks = new ArrayList<Runnable>();

        private TasksRunner() {
        }

        @Override
        public void startNotified(ProcessEvent event) {
            ProcessHandler.this.removeProcessListener(this);
            this.runPendingTasks();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute(Runnable task) {
            if (ProcessHandler.this.isStartNotified()) {
                task.run();
            } else {
                List<Runnable> list = this.myPendingTasks;
                synchronized (list) {
                    this.myPendingTasks.add(task);
                }
                if (ProcessHandler.this.isStartNotified()) {
                    this.runPendingTasks();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runPendingTasks() {
            Runnable[] tasks;
            List<Runnable> list = this.myPendingTasks;
            synchronized (list) {
                tasks = this.myPendingTasks.toArray(new Runnable[this.myPendingTasks.size()]);
                this.myPendingTasks.clear();
            }
            for (Runnable task : tasks) {
                task.run();
            }
        }
    }
}

