/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android.builder;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.builder.AndroidAarDepsBuildTarget;
import org.jetbrains.jps.android.builder.AndroidLibraryPackagingTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildRootIndex;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.BuildTargetLoader;
import org.jetbrains.jps.builders.BuildTargetRegistry;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.TargetOutputIndex;
import org.jetbrains.jps.builders.impl.BuildRootDescriptorImpl;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.indices.IgnoredFileIndex;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.module.JpsDependencyElement;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleDependency;

public class AndroidPreDexBuildTarget
extends BuildTarget<MyRootDescriptor> {
    private static final String ID = "only";
    private final JpsProject myProject;
    public static final String PRE_DEXED_LIBS_DIRECTORY_NAME = "pre_dexed_libs";

    public AndroidPreDexBuildTarget(JpsProject project) {
        super((BuildTargetType)MyTargetType.INSTANCE);
        this.myProject = project;
    }

    public String getId() {
        return ID;
    }

    public Collection<BuildTarget<?>> computeDependencies(BuildTargetRegistry targetRegistry, TargetOutputIndex outputIndex) {
        ArrayList result = new ArrayList();
        for (JpsModule module : this.myProject.getModules()) {
            JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
            if (extension == null) continue;
            if (extension.isLibrary()) {
                result.add(new AndroidLibraryPackagingTarget(module));
                continue;
            }
            result.add(new AndroidAarDepsBuildTarget(module));
        }
        return result;
    }

    private static void fillDepsRecursively(JpsModule root, Set<JpsModule> libModules, Set<String> externalJars, BuildDataPaths dataPaths, AndroidPlatform platform) {
        for (String jarOrLibDirPath : AndroidJpsUtil.getExternalLibraries(dataPaths, root, platform, false, false, true)) {
            String path = FileUtil.toCanonicalPath((String)jarOrLibDirPath);
            if (path == null) continue;
            externalJars.add(path);
        }
        for (JpsDependencyElement dependencyElement : root.getDependenciesList().getDependencies()) {
            JpsAndroidModuleExtension depExtension;
            JpsModule depModule;
            if (!(dependencyElement instanceof JpsModuleDependency) || (depModule = ((JpsModuleDependency)dependencyElement).getModule()) == null || (depExtension = AndroidJpsUtil.getExtension(depModule)) == null || !depExtension.isLibrary() || !libModules.add(depModule)) continue;
            AndroidPreDexBuildTarget.fillDepsRecursively(depModule, libModules, externalJars, dataPaths, platform);
        }
    }

    public List<MyRootDescriptor> computeRootDescriptors(JpsModel model, ModuleExcludeIndex index, IgnoredFileIndex ignoredFileIndex, BuildDataPaths dataPaths) {
        ArrayList<MyRootDescriptor> result = new ArrayList<MyRootDescriptor>();
        HashSet libModules = new HashSet();
        HashSet externalJars = new HashSet();
        for (JpsModule module : this.myProject.getModules()) {
            AndroidPlatform platform;
            JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
            if (extension == null || extension.isLibrary() || !extension.isPreDexingEnabled() || (platform = AndroidJpsUtil.getAndroidPlatform(module, null, null)) == null) continue;
            AndroidPreDexBuildTarget.fillDepsRecursively(module, (Set<JpsModule>)libModules, (Set<String>)externalJars, dataPaths, platform);
        }
        for (JpsModule libModule : libModules) {
            File classesJarFile = new AndroidLibraryPackagingTarget(libModule).getOutputFile(dataPaths);
            result.add(new MyRootDescriptor(this, classesJarFile, libModule.getName()));
        }
        for (String externalJarPath : externalJars) {
            result.add(new MyRootDescriptor(this, new File(externalJarPath), null));
        }
        return result;
    }

    public MyRootDescriptor findRootDescriptor(String rootId, BuildRootIndex rootIndex) {
        for (MyRootDescriptor descriptor : rootIndex.getTargetRoots((BuildTarget)this, null)) {
            if (!descriptor.getRootId().equals(rootId)) continue;
            return descriptor;
        }
        return null;
    }

    public String getPresentableName() {
        return "Android Pre-DEX";
    }

    public Collection<File> getOutputRoots(CompileContext context) {
        return Collections.singletonList(this.getOutputFile(context));
    }

    public File getOutputFile(CompileContext context) {
        return AndroidPreDexBuildTarget.getOutputDir(context.getProjectDescriptor().dataManager.getDataPaths());
    }

    public static File getOutputDir(BuildDataPaths dataPaths) {
        File dir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(dataPaths);
        return new File(dir, PRE_DEXED_LIBS_DIRECTORY_NAME);
    }

    public JpsProject getProject() {
        return this.myProject;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AndroidPreDexBuildTarget target = (AndroidPreDexBuildTarget)((Object)o);
        return this.myProject.equals(target.myProject);
    }

    public int hashCode() {
        return this.myProject.hashCode();
    }

    public static class MyRootDescriptor
    extends BuildRootDescriptorImpl {
        private final String myModuleName;

        private MyRootDescriptor(BuildTarget target, File root, String moduleName) {
            super(target, root);
            this.myModuleName = moduleName;
        }

        public String getModuleName() {
            return this.myModuleName;
        }
    }

    public static class MyTargetType
    extends BuildTargetType<AndroidPreDexBuildTarget> {
        public static final MyTargetType INSTANCE = new MyTargetType();

        private MyTargetType() {
            super("android-pre-dex");
        }

        public List<AndroidPreDexBuildTarget> computeAllTargets(JpsModel model) {
            if (!AndroidJpsUtil.isAndroidProjectWithoutGradleFacet(model.getProject())) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new AndroidPreDexBuildTarget(model.getProject()));
        }

        public BuildTargetLoader<AndroidPreDexBuildTarget> createLoader(JpsModel model) {
            final JpsProject project = model.getProject();
            return new BuildTargetLoader<AndroidPreDexBuildTarget>(){

                public AndroidPreDexBuildTarget createTarget(String targetId) {
                    return AndroidPreDexBuildTarget.ID.equals(targetId) && AndroidJpsUtil.isAndroidProjectWithoutGradleFacet(project) ? new AndroidPreDexBuildTarget(project) : null;
                }
            };
        }
    }
}

