/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.tools.idea.jps.AndroidTargetBuilder;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashSet;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.android.util.AndroidBuildTestingManager;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.android.AndroidJpsBundle;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.builder.AndroidLibraryPackagingTarget;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.BuildOutputConsumer;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.ProgressMessage;
import org.jetbrains.jps.model.module.JpsModule;

public class AndroidLibraryPackagingBuilder
extends AndroidTargetBuilder<BuildRootDescriptor, AndroidLibraryPackagingTarget> {
    private static final String BUILDER_NAME = "Android Library Packaging";

    protected AndroidLibraryPackagingBuilder() {
        super(Collections.singletonList(AndroidLibraryPackagingTarget.MyTargetType.INSTANCE));
    }

    @Override
    protected void buildTarget(AndroidLibraryPackagingTarget target, DirtyFilesHolder<BuildRootDescriptor, AndroidLibraryPackagingTarget> holder, BuildOutputConsumer outputConsumer, CompileContext context) throws ProjectBuildException, IOException {
        if (!holder.hasDirtyFiles() && !holder.hasRemovedFiles()) {
            return;
        }
        assert (!AndroidJpsUtil.isLightBuild(context));
        if (!AndroidLibraryPackagingBuilder.doBuild(context, target.getModule(), outputConsumer)) {
            throw new StopBuildException();
        }
    }

    private static boolean doBuild(CompileContext context, JpsModule module, BuildOutputConsumer outputConsumer) throws IOException {
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getExtension(module);
        if (extension == null || !extension.isLibrary()) {
            return true;
        }
        File outputDir = AndroidJpsUtil.getDirectoryForIntermediateArtifacts(context, module);
        if ((outputDir = AndroidJpsUtil.createDirIfNotExist(outputDir, context, BUILDER_NAME)) == null) {
            return false;
        }
        File classesDir = ProjectPaths.getModuleOutputDir((JpsModule)module, (boolean)false);
        if (classesDir == null || !classesDir.isDirectory()) {
            return true;
        }
        HashSet subdirs = new HashSet();
        AndroidJpsUtil.addSubdirectories(classesDir, (Collection<String>)subdirs);
        if (subdirs.size() > 0) {
            List srcFiles;
            context.processMessage((BuildMessage)new ProgressMessage(AndroidJpsBundle.message("android.jps.progress.library.packaging", module.getName())));
            File outputJarFile = new File(outputDir, "classes.jar");
            try {
                srcFiles = AndroidCommonUtils.packClassFilesIntoJar((String[])ArrayUtil.EMPTY_STRING_ARRAY, (String[])ArrayUtil.toStringArray((Collection)subdirs), (File)outputJarFile);
            }
            catch (IOException e) {
                AndroidJpsUtil.reportExceptionError(context, null, e, BUILDER_NAME);
                return false;
            }
            AndroidBuildTestingManager testingManager = AndroidBuildTestingManager.getTestingManager();
            if (testingManager != null && outputJarFile.isFile()) {
                testingManager.getCommandExecutor().checkJarContent("library_package_jar", outputJarFile.getPath());
            }
            if (srcFiles.size() > 0) {
                outputConsumer.registerOutputFile(outputJarFile, (Collection)srcFiles);
            }
        }
        return true;
    }

    public String getPresentableName() {
        return BUILDER_NAME;
    }
}

