/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.android;

import com.android.sdklib.IAndroidTarget;
import com.intellij.util.Base64Converter;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.compiler.artifact.AndroidArtifactSigningMode;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.jps.android.AndroidJpsUtil;
import org.jetbrains.jps.android.AndroidPlatform;
import org.jetbrains.jps.android.model.AndroidApplicationArtifactType;
import org.jetbrains.jps.android.model.JpsAndroidApplicationArtifactProperties;
import org.jetbrains.jps.android.model.JpsAndroidModuleExtension;
import org.jetbrains.jps.builders.artifacts.ArtifactBuildTaskProvider;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.util.JpsPathUtil;

public class AndroidArtifactBuildTaskProvider
extends ArtifactBuildTaskProvider {
    private static final String BUILDER_NAME = "Android Artifact Processor";

    public List<? extends BuildTask> createArtifactBuildTasks(JpsArtifact artifact, ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        if (buildPhase != ArtifactBuildTaskProvider.ArtifactBuildPhase.FINISHING_BUILD) {
            return Collections.emptyList();
        }
        if (!(artifact.getArtifactType() instanceof AndroidApplicationArtifactType)) {
            return Collections.emptyList();
        }
        JpsElement props = artifact.getProperties();
        if (!(props instanceof JpsAndroidApplicationArtifactProperties)) {
            return Collections.emptyList();
        }
        JpsAndroidApplicationArtifactProperties androidProps = (JpsAndroidApplicationArtifactProperties)props;
        if (!(artifact.getArtifactType() instanceof AndroidApplicationArtifactType)) {
            return Collections.emptyList();
        }
        AndroidArtifactSigningMode signingMode = androidProps.getSigningMode();
        if (signingMode != AndroidArtifactSigningMode.RELEASE_SIGNED && signingMode != AndroidArtifactSigningMode.DEBUG_WITH_CUSTOM_CERTIFICATE) {
            return Collections.emptyList();
        }
        JpsAndroidModuleExtension extension = AndroidJpsUtil.getPackagedFacet(artifact);
        return extension != null ? Collections.singletonList(new MyTask(artifact, extension, androidProps)) : Collections.emptyList();
    }

    private static class MyTask
    extends BuildTask {
        private final JpsArtifact myArtifact;
        private final JpsAndroidModuleExtension myExtension;
        private final JpsAndroidApplicationArtifactProperties myProps;

        private MyTask(JpsArtifact artifact, JpsAndroidModuleExtension extension, JpsAndroidApplicationArtifactProperties props) {
            this.myArtifact = artifact;
            this.myExtension = extension;
            this.myProps = props;
        }

        public void build(CompileContext context) throws ProjectBuildException {
            String artifactName = this.myArtifact.getName();
            String entryName = "Artifact '" + artifactName + "'";
            String messagePrefix = "[" + entryName + "] ";
            JpsModule module = this.myExtension.getModule();
            AndroidPlatform platform = AndroidJpsUtil.getAndroidPlatform(module, context, AndroidArtifactBuildTaskProvider.BUILDER_NAME);
            if (platform == null) {
                return;
            }
            String sdkLocation = platform.getSdk().getHomePath();
            String artifactFilePath = this.myArtifact.getOutputFilePath();
            String keyStorePath = this.myProps.getKeyStoreUrl() != null ? JpsPathUtil.urlToPath((String)this.myProps.getKeyStoreUrl()) : "";
            String keyStorePassword = this.myProps.getKeyStorePassword();
            String plainKeyStorePassword = keyStorePassword != null && keyStorePassword.length() > 0 ? Base64Converter.decode((String)keyStorePassword) : null;
            String keyPassword = this.myProps.getKeyPassword();
            String plainKeyPassword = keyPassword != null && keyPassword.length() > 0 ? Base64Converter.decode((String)keyPassword) : null;
            try {
                Map messages = AndroidCommonUtils.buildArtifact((String)artifactName, (String)messagePrefix, (String)sdkLocation, (IAndroidTarget)platform.getTarget(), (String)artifactFilePath, (String)keyStorePath, (String)this.myProps.getKeyAlias(), (String)plainKeyStorePassword, (String)plainKeyPassword);
                AndroidJpsUtil.addMessages(context, messages, AndroidArtifactBuildTaskProvider.BUILDER_NAME, entryName);
            }
            catch (GeneralSecurityException e) {
                AndroidJpsUtil.reportExceptionError(context, null, e, AndroidArtifactBuildTaskProvider.BUILDER_NAME);
            }
            catch (IOException e) {
                AndroidJpsUtil.reportExceptionError(context, null, e, AndroidArtifactBuildTaskProvider.BUILDER_NAME);
            }
        }
    }
}

