/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.agent.rt.internal_e6e56f0.core.internal.instr;

import org.jacoco.agent.rt.internal_e6e56f0.asm.Label;
import org.jacoco.agent.rt.internal_e6e56f0.asm.MethodVisitor;
import org.jacoco.agent.rt.internal_e6e56f0.core.internal.flow.IFrame;
import org.jacoco.agent.rt.internal_e6e56f0.core.internal.flow.LabelInfo;
import org.jacoco.agent.rt.internal_e6e56f0.core.internal.flow.MethodProbesVisitor;
import org.jacoco.agent.rt.internal_e6e56f0.core.internal.instr.IProbeInserter;

class MethodInstrumenter
extends MethodProbesVisitor {
    private final IProbeInserter probeInserter;

    public MethodInstrumenter(MethodVisitor mv, IProbeInserter probeInserter) {
        super(mv);
        this.probeInserter = probeInserter;
    }

    public void visitProbe(int probeId) {
        this.probeInserter.insertProbe(probeId);
    }

    public void visitInsnWithProbe(int opcode, int probeId) {
        this.probeInserter.insertProbe(probeId);
        this.mv.visitInsn(opcode);
    }

    public void visitJumpInsnWithProbe(int opcode, Label label, int probeId, IFrame frame) {
        if (opcode == 167) {
            this.probeInserter.insertProbe(probeId);
            this.mv.visitJumpInsn(167, label);
        } else {
            Label intermediate = new Label();
            this.mv.visitJumpInsn(this.getInverted(opcode), intermediate);
            this.probeInserter.insertProbe(probeId);
            this.mv.visitJumpInsn(167, label);
            this.mv.visitLabel(intermediate);
            frame.accept(this.mv);
        }
    }

    private int getInverted(int opcode) {
        switch (opcode) {
            case 153: {
                return 154;
            }
            case 154: {
                return 153;
            }
            case 155: {
                return 156;
            }
            case 156: {
                return 155;
            }
            case 157: {
                return 158;
            }
            case 158: {
                return 157;
            }
            case 159: {
                return 160;
            }
            case 160: {
                return 159;
            }
            case 161: {
                return 162;
            }
            case 162: {
                return 161;
            }
            case 163: {
                return 164;
            }
            case 164: {
                return 163;
            }
            case 165: {
                return 166;
            }
            case 166: {
                return 165;
            }
            case 198: {
                return 199;
            }
            case 199: {
                return 198;
            }
        }
        throw new IllegalArgumentException();
    }

    public void visitTableSwitchInsnWithProbes(int min, int max, Label dflt, Label[] labels, IFrame frame) {
        LabelInfo.resetDone(dflt);
        LabelInfo.resetDone(labels);
        Label newDflt = this.createIntermediate(dflt);
        Label[] newLabels = this.createIntermediates(labels);
        this.mv.visitTableSwitchInsn(min, max, newDflt, newLabels);
        this.insertIntermediateProbes(dflt, labels, frame);
    }

    public void visitLookupSwitchInsnWithProbes(Label dflt, int[] keys, Label[] labels, IFrame frame) {
        LabelInfo.resetDone(dflt);
        LabelInfo.resetDone(labels);
        Label newDflt = this.createIntermediate(dflt);
        Label[] newLabels = this.createIntermediates(labels);
        this.mv.visitLookupSwitchInsn(newDflt, keys, newLabels);
        this.insertIntermediateProbes(dflt, labels, frame);
    }

    private Label[] createIntermediates(Label[] labels) {
        Label[] intermediates = new Label[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            intermediates[i] = this.createIntermediate(labels[i]);
        }
        return intermediates;
    }

    private Label createIntermediate(Label label) {
        Label intermediate;
        if (LabelInfo.getProbeId(label) == -1) {
            intermediate = label;
        } else if (LabelInfo.isDone(label)) {
            intermediate = LabelInfo.getIntermediateLabel(label);
        } else {
            intermediate = new Label();
            LabelInfo.setIntermediateLabel(label, intermediate);
            LabelInfo.setDone(label);
        }
        return intermediate;
    }

    private void insertIntermediateProbe(Label label, IFrame frame) {
        int probeId = LabelInfo.getProbeId(label);
        if (probeId != -1 && !LabelInfo.isDone(label)) {
            this.mv.visitLabel(LabelInfo.getIntermediateLabel(label));
            frame.accept(this.mv);
            this.probeInserter.insertProbe(probeId);
            this.mv.visitJumpInsn(167, label);
            LabelInfo.setDone(label);
        }
    }

    private void insertIntermediateProbes(Label dflt, Label[] labels, IFrame frame) {
        LabelInfo.resetDone(dflt);
        LabelInfo.resetDone(labels);
        this.insertIntermediateProbe(dflt, frame);
        for (Label l : labels) {
            this.insertIntermediateProbe(l, frame);
        }
    }
}

