/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import com.esotericsoftware.kryo.util.Util;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

public class UnsafeUtil {
    private static final Unsafe _unsafe;
    public static final long byteArrayBaseOffset;
    public static final long floatArrayBaseOffset;
    public static final long doubleArrayBaseOffset;
    public static final long intArrayBaseOffset;
    public static final long longArrayBaseOffset;
    public static final long shortArrayBaseOffset;
    public static final long charArrayBaseOffset;
    static Constructor<? extends ByteBuffer> directByteBufferConstr;

    public static final Unsafe unsafe() {
        return _unsafe;
    }

    public static Field[] sortFieldsByOffset(List<Field> list) {
        Field[] fieldArray = list.toArray(new Field[0]);
        Comparator<Field> comparator = new Comparator<Field>(){

            @Override
            public int compare(Field field, Field field2) {
                long l;
                long l2 = UnsafeUtil.unsafe().objectFieldOffset(field);
                if (l2 < (l = UnsafeUtil.unsafe().objectFieldOffset(field2))) {
                    return -1;
                }
                if (l2 == l) {
                    return 0;
                }
                return 1;
            }
        };
        Arrays.sort(fieldArray, comparator);
        for (Field field : list) {
        }
        return fieldArray;
    }

    public static final ByteBuffer getDirectBufferAt(long l, int n) {
        if (directByteBufferConstr == null) {
            return null;
        }
        try {
            return directByteBufferConstr.newInstance(l, n, null);
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot allocate ByteBuffer at a given address: " + l, exception);
        }
    }

    public static void releaseBuffer(ByteBuffer byteBuffer) {
        if (byteBuffer != null && byteBuffer.isDirect()) {
            Cleaner cleaner = ((DirectBuffer)((Object)byteBuffer)).cleaner();
            if (cleaner != null) {
                cleaner.clean();
            }
            byteBuffer = null;
        }
    }

    static {
        Object object;
        try {
            if (!Util.isAndroid) {
                object = Unsafe.class.getDeclaredField("theUnsafe");
                ((Field)object).setAccessible(true);
                _unsafe = (Unsafe)((Field)object).get(null);
                byteArrayBaseOffset = _unsafe.arrayBaseOffset(byte[].class);
                charArrayBaseOffset = _unsafe.arrayBaseOffset(char[].class);
                shortArrayBaseOffset = _unsafe.arrayBaseOffset(short[].class);
                intArrayBaseOffset = _unsafe.arrayBaseOffset(int[].class);
                floatArrayBaseOffset = _unsafe.arrayBaseOffset(float[].class);
                longArrayBaseOffset = _unsafe.arrayBaseOffset(long[].class);
                doubleArrayBaseOffset = _unsafe.arrayBaseOffset(double[].class);
            } else {
                byteArrayBaseOffset = 0L;
                charArrayBaseOffset = 0L;
                shortArrayBaseOffset = 0L;
                intArrayBaseOffset = 0L;
                floatArrayBaseOffset = 0L;
                longArrayBaseOffset = 0L;
                doubleArrayBaseOffset = 0L;
                _unsafe = null;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        object = ByteBuffer.allocateDirect(1);
        try {
            directByteBufferConstr = object.getClass().getDeclaredConstructor(Long.TYPE, Integer.TYPE, Object.class);
            directByteBufferConstr.setAccessible(true);
        }
        catch (Exception exception) {
            directByteBufferConstr = null;
        }
    }
}

