/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.HashMap;
import java.util.List;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import org.testng.IDEATestNGRemoteListener;
import org.testng.ITestListener;
import org.testng.TestNG;
import org.testng.collections.Lists;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IDEARemoteTestNG
extends TestNG {
    private static void calculateAllSuites(List<XmlSuite> suites, List<XmlSuite> outSuites) {
        for (XmlSuite s : suites) {
            outSuites.add(s);
            IDEARemoteTestNG.calculateAllSuites(s.getChildSuites(), outSuites);
        }
    }

    public void run() {
        try {
            this.initializeSuitesAndJarFile();
            List suites = Lists.newArrayList();
            IDEARemoteTestNG.calculateAllSuites(this.m_suites, suites);
            if (suites.size() > 0) {
                int testCount = 0;
                for (XmlSuite suite : suites) {
                    List tests = suite.getTests();
                    for (XmlTest test : tests) {
                        testCount += test.getClasses().size();
                    }
                }
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("count", String.valueOf(testCount));
                System.out.println(ServiceMessage.asString((String)"testCount", map));
                this.addListener(new IDEATestNGRemoteListener());
                this.addListener((ITestListener)new IDEATestNGRemoteListener());
                super.run();
            } else {
                System.err.println("Nothing found to run");
            }
        }
        catch (Throwable cause) {
            cause.printStackTrace(System.err);
        }
    }
}

