/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.siyeh.ig.BaseInspectionVisitor;
import com.siyeh.ig.InspectionGadgetsFix;
import com.siyeh.ig.fixes.RenameFix;
import com.siyeh.ig.naming.ConventionInspection;
import com.siyeh.ig.psiutils.LibraryUtil;
import com.siyeh.ig.psiutils.MethodUtils;
import com.theoryinpractice.testng.util.TestNGUtil;

public class TestNGMethodNamingConventionInspection
extends ConventionInspection {
    public String getDisplayName() {
        return "TestNG test method naming convention";
    }

    protected String buildErrorString(Object ... infos) {
        String methodName = (String)infos[0];
        int length = methodName.length();
        if (length < this.getMinLength()) {
            return "TestNG test method name <code>#ref</code> is too short (" + length + " < " + this.getMinLength() + ") #loc";
        }
        if (length > this.getMaxLength()) {
            return "TestNG test method name <code>#ref</code> is too long (" + length + " > " + this.getMaxLength() + ") #loc";
        }
        return "JUnit4 test method name <code>#ref</code> doesn't match regex '{0}' #loc";
    }

    protected String getDefaultRegex() {
        return "[a-z][A-Za-z_\\d]*";
    }

    protected int getDefaultMinLength() {
        return 4;
    }

    protected int getDefaultMaxLength() {
        return 64;
    }

    protected InspectionGadgetsFix buildFix(Object ... infos) {
        return new RenameFix();
    }

    public BaseInspectionVisitor buildVisitor() {
        return new TestNGMethodNamingConventionVisitor();
    }

    private class TestNGMethodNamingConventionVisitor
    extends BaseInspectionVisitor {
        private TestNGMethodNamingConventionVisitor() {
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            if (!TestNGUtil.hasTest((PsiModifierListOwner)method)) {
                return;
            }
            PsiIdentifier nameIdentifier = method.getNameIdentifier();
            if (nameIdentifier == null) {
                return;
            }
            String name = method.getName();
            if (TestNGMethodNamingConventionInspection.this.isValid(name)) {
                return;
            }
            if (!this.isOnTheFly() && MethodUtils.hasSuper((PsiMethod)method)) {
                return;
            }
            if (LibraryUtil.isOverrideOfLibraryMethod((PsiMethod)method)) {
                return;
            }
            this.registerMethodError(method, new Object[]{name});
        }
    }
}

