/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.inspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiArrayInitializerMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DependsOnMethodInspection
extends BaseJavaLocalInspectionTool {
    private static final Logger LOGGER = Logger.getInstance((String)"TestNG Runner");
    private static final Pattern PATTERN = Pattern.compile("\"([a-zA-Z1-9_\\(\\)\\*]*)\"");

    public String getGroupDisplayName() {
        return "TestNG";
    }

    public String getDisplayName() {
        return "dependsOnMethods problem";
    }

    public String getShortName() {
        return "dependsOnMethodTestNG";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public ProblemDescriptor[] checkClass(PsiClass psiClass, InspectionManager manager, boolean isOnTheFly) {
        PsiAnnotation[] annotations = TestNGUtil.getTestNGAnnotations((PsiElement)psiClass);
        if (annotations.length == 0) {
            return ProblemDescriptor.EMPTY_ARRAY;
        }
        ArrayList<ProblemDescriptor> problemDescriptors = new ArrayList<ProblemDescriptor>();
        for (PsiAnnotation annotation : annotations) {
            PsiExpression initializer;
            PsiElement resolve;
            PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue("dependsOnMethods");
            if (value == null || TestNGUtil.isDisabled(annotation)) continue;
            String text = value.getText();
            if (value instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)value).resolve()) instanceof PsiField && ((PsiField)resolve).hasModifierProperty("static") && ((PsiField)resolve).hasModifierProperty("final") && (initializer = ((PsiField)resolve).getInitializer()) != null) {
                text = initializer.getText();
            }
            HashSet names = new HashSet();
            Matcher matcher = PATTERN.matcher(text);
            int idx = 0;
            while (matcher.find()) {
                String methodName = matcher.group(1);
                if (!names.add(methodName)) {
                    PsiAnnotationMemberValue[] initializers;
                    PsiAnnotationMemberValue element2Highlight = value;
                    if (value instanceof PsiArrayInitializerMemberValue && idx < (initializers = ((PsiArrayInitializerMemberValue)value).getInitializers()).length) {
                        element2Highlight = initializers[idx];
                    }
                    problemDescriptors.add(manager.createProblemDescriptor((PsiElement)element2Highlight, "Duplicated method name: " + methodName, (LocalQuickFix)null, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
                }
                DependsOnMethodInspection.checkMethodNameDependency(manager, psiClass, methodName, value, problemDescriptors, isOnTheFly);
                ++idx;
            }
        }
        return problemDescriptors.toArray(new ProblemDescriptor[problemDescriptors.size()]);
    }

    private static void checkMethodNameDependency(InspectionManager manager, PsiClass psiClass, String methodName, PsiAnnotationMemberValue value, List<ProblemDescriptor> problemDescriptors, boolean onTheFly) {
        LOGGER.debug("Found dependsOnMethods with text: " + methodName);
        if (methodName.length() > 0 && methodName.charAt(methodName.length() - 1) == ')') {
            LOGGER.debug("dependsOnMethods contains ()" + psiClass.getName());
            ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)value, "Method '" + methodName + "' should not include () characters.", (LocalQuickFix)null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly);
            problemDescriptors.add(descriptor);
        } else {
            PsiMethod[] foundMethods;
            String configAnnotation = TestNGUtil.getConfigAnnotation((PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)value, PsiMethod.class));
            if (methodName.endsWith("*")) {
                final String methodNameMask = StringUtil.trimEnd((String)methodName, (String)"*");
                List methods = ContainerUtil.filter((Object[])psiClass.getMethods(), (Condition)new Condition<PsiMethod>(){

                    public boolean value(PsiMethod method) {
                        return method.getName().startsWith(methodNameMask);
                    }
                });
                foundMethods = methods.toArray(new PsiMethod[methods.size()]);
            } else {
                foundMethods = psiClass.findMethodsByName(methodName, true);
            }
            if (foundMethods.length == 0) {
                LOGGER.debug("dependsOnMethods method doesn't exist:" + methodName);
                ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)value, "Method '" + methodName + "' unknown.", (LocalQuickFix)null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly);
                problemDescriptors.add(descriptor);
            } else {
                boolean hasTestsOrConfigs = false;
                for (PsiMethod foundMethod : foundMethods) {
                    if (configAnnotation != null) {
                        hasTestsOrConfigs |= AnnotationUtil.isAnnotated((PsiModifierListOwner)foundMethod, (String)configAnnotation, (boolean)true);
                        continue;
                    }
                    hasTestsOrConfigs |= TestNGUtil.hasTest((PsiModifierListOwner)foundMethod);
                }
                if (!hasTestsOrConfigs) {
                    ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)value, configAnnotation == null ? "Method '" + methodName + "' is not a test or configuration method." : "Method '" + methodName + "' is not annotated with @" + configAnnotation, (LocalQuickFix)null, ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, onTheFly);
                    problemDescriptors.add(descriptor);
                }
            }
        }
    }
}

