/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration.browser;

import com.intellij.execution.configuration.BrowseModuleValueActionListener;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.theoryinpractice.testng.configuration.TestNGConfigurationEditor;
import com.theoryinpractice.testng.configuration.browser.GroupList;
import com.theoryinpractice.testng.model.TestClassFilter;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.awt.Component;
import javax.swing.Icon;

public class GroupBrowser
extends BrowseModuleValueActionListener {
    private final TestNGConfigurationEditor editor;

    public GroupBrowser(Project project, TestNGConfigurationEditor editor) {
        super(project);
        this.editor = editor;
    }

    protected String showDialog() {
        Module module = this.editor.getModuleSelector().getModule();
        TestClassFilter filter = module == null ? new TestClassFilter(GlobalSearchScope.projectScope((Project)this.getProject()), this.getProject(), false) : new TestClassFilter(GlobalSearchScope.moduleScope((Module)module), this.getProject(), false);
        PsiClass[] classes = TestNGUtil.getAllTestClasses(filter, true);
        if (classes == null || classes.length == 0) {
            Messages.showMessageDialog((Component)this.getField(), (String)"No tests found in project", (String)"Cannot Browse Groups", (Icon)Messages.getInformationIcon());
            return null;
        }
        return GroupList.showDialog(classes, this.getField());
    }
}

