/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.fetchasgoogle;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.http.FileContent;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson.JacksonFactory;
import com.google.api.client.util.Lists;
import com.google.api.services.fetch_as_google_pa.FetchAsGooglePa;
import com.google.api.services.fetch_as_google_pa.model.Apk;
import com.google.api.services.fetch_as_google_pa.model.ApkDataRef;
import com.google.api.services.fetch_as_google_pa.model.ApkHolder;
import com.google.api.services.fetch_as_google_pa.model.FetchRequest;
import com.google.api.services.fetch_as_google_pa.model.FetchResponse;
import com.google.api.services.fetch_as_google_pa.model.Intent;
import com.google.api.services.fetch_as_google_pa.model.Operation;
import com.google.api.services.fetch_as_google_pa.model.ReferencedResource;
import com.google.gct.login.CredentialedUser;
import com.google.gct.login.GoogleLogin;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public final class FetchAsGoogleClient {
    private static final NetHttpTransport httpTransport = new NetHttpTransport();
    private static final JsonFactory jsonFactory = new JacksonFactory();
    private static final String SERVER_PATH = "";
    private static final String ROOT_URL = "https://test-fetch-as-google-pa.sandbox.googleapis.com";
    private static final String MIME_TYPE = "application/vnd.android.package-archive";
    private static final int CHUNK_SIZE = 1024;
    private static final int KB = 1024;
    private static final String UPLOAD_SOURCE = "ANDROID_STUDIO";
    private static final String URL_TYPE_KEY = "@type";
    private static final String URL_TYPE = "type.googleapis.com/google.internal.fetchasgoogle.v1.FetchResponse";
    private static final String STATUS_KEY = "status";
    private static final String SCREENSHOT_DATA_KEY = "screenshotData";
    private static final String REFERENCED_RESOURCE_KEY = "referencedResource";
    private static final String REQUEST_KEY = "request";
    private static final String RESPONSE_KEY = "response";
    private static final String FETCH_STATUS_KEY = "fetchStatus";
    private static final String OK_STATUS = "OK";
    private static final String PENDING_STATUS = "PENDING";
    private static final int FETCH_TIME_INTERVAL_IN_MS = 5000;
    private FetchAsGooglePa myStub;

    public static FetchAsGoogleClient createInstance() throws FetchAsGoogleException {
        FetchAsGooglePa stub = FetchAsGoogleClient.createStub();
        if (stub == null) {
            throw new FetchAsGoogleException("Could not find user credentials", FetchAsGoogleException.ErrorCode.NO_CREDENTIAL);
        }
        return new FetchAsGoogleClient(stub);
    }

    private FetchAsGoogleClient(FetchAsGooglePa stub) {
        this.myStub = stub;
    }

    private static FetchAsGooglePa createStub() {
        CredentialedUser user = GoogleLogin.getInstance().getActiveUser();
        if (user != null) {
            return new FetchAsGooglePa.Builder((HttpTransport)httpTransport, jsonFactory, (HttpRequestInitializer)new FetchAsGoogleHttpRequestInitializer(user.getCredential())).setServicePath(SERVER_PATH).setRootUrl(ROOT_URL).build();
        }
        return null;
    }

    public ApkHolder uploadApk(String packageId, File apkFile) throws FetchAsGoogleException, IOException {
        ApkDataRef apkDataRef = (ApkDataRef)this.myStub.apks().startUpload().execute();
        FetchAsGooglePa.Media.Upload upload = this.myStub.media().upload(apkDataRef.getResourceName(), null, (AbstractInputStreamContent)new FileContent(MIME_TYPE, apkFile));
        upload.getMediaHttpUploader().setDirectUploadEnabled(true);
        upload.getMediaHttpUploader().setChunkSize(0x100000);
        HttpResponse response = upload.executeUnparsed();
        if (response.getStatusCode() != 200) {
            throw new FetchAsGoogleException("Failed to upload Apk: " + response, FetchAsGoogleException.ErrorCode.SERVER_ERROR);
        }
        Apk feagApk = new Apk().setPackageId(packageId).setSource(UPLOAD_SOURCE);
        ApkHolder apk = new ApkHolder().setApk(feagApk).setApkDataRef(apkDataRef);
        return (ApkHolder)this.myStub.apks().create(apk).execute();
    }

    public FetchResponse fetchAsGoogle(String deepLink, ApkHolder apkHolder) throws FetchAsGoogleException, IOException, InterruptedException {
        Operation startFetchResult = this.startFetch(deepLink, apkHolder);
        if (startFetchResult == null) {
            throw new FetchAsGoogleException("Operation failed with an empty response", FetchAsGoogleException.ErrorCode.SERVER_ERROR);
        }
        Operation result = null;
        String fetchToken = startFetchResult.getName();
        if (fetchToken == null || fetchToken.isEmpty()) {
            throw new FetchAsGoogleException("No fetch token returned", FetchAsGoogleException.ErrorCode.SERVER_ERROR);
        }
        do {
            Thread.sleep(5000L);
            result = this.getFetchResult(fetchToken);
            if (result == null) {
                throw new FetchAsGoogleException("Operation failed with an empty response", FetchAsGoogleException.ErrorCode.SERVER_ERROR);
            }
            if (result.getDone() == null || !result.getDone().booleanValue()) continue;
            if (result.getError() != null) {
                throw new FetchAsGoogleException("Operation failed with error status: " + result.getError(), FetchAsGoogleException.ErrorCode.GENERIC_ERROR);
            }
            if (result.getResponse() == null) {
                throw new FetchAsGoogleException("Operation failed with an empty response", FetchAsGoogleException.ErrorCode.SERVER_ERROR);
            }
            if (!result.getResponse().get(URL_TYPE_KEY).equals(URL_TYPE)) {
                throw new FetchAsGoogleException("Operation response contains unexpected type: " + result.getResponse().get(URL_TYPE_KEY), FetchAsGoogleException.ErrorCode.SERVER_ERROR);
            }
            if (result.getResponse().get(STATUS_KEY) == null) {
                throw new FetchAsGoogleException("Operation failed with an empty status", FetchAsGoogleException.ErrorCode.SERVER_ERROR);
            }
            if (result.getResponse().get(STATUS_KEY).equals(OK_STATUS)) continue;
            throw new FetchAsGoogleException("Operation failed with error status: " + result.getResponse().get(STATUS_KEY), FetchAsGoogleException.ErrorCode.GENERIC_ERROR);
        } while (result.getDone() == null || !result.getDone().booleanValue());
        return this.constructFetchResponse(result.getResponse());
    }

    private FetchResponse constructFetchResponse(Map<String, Object> map) {
        List referencedResource;
        FetchResponse response = new FetchResponse();
        response.setStatus((String)map.get(STATUS_KEY));
        if (map.get(SCREENSHOT_DATA_KEY) != null) {
            response.setScreenshotData((String)map.get(SCREENSHOT_DATA_KEY));
        }
        if ((referencedResource = (List)map.get(REFERENCED_RESOURCE_KEY)) != null) {
            ArrayList resources = Lists.newArrayList();
            for (Map resource : referencedResource) {
                resources.add(new ReferencedResource().setFetchStatus((String)resource.get(FETCH_STATUS_KEY)).setRequest((String)resource.get(REQUEST_KEY)).setResponse((String)resource.get(RESPONSE_KEY)));
            }
        }
        return response;
    }

    private Operation startFetch(String deepLink, ApkHolder apkHolder) throws IOException {
        FetchRequest request = new FetchRequest().setPackageId(apkHolder.getApk().getPackageId()).setApkId(apkHolder.getApk().getApkId()).setIntent(new Intent().setUri(deepLink)).setSource(UPLOAD_SOURCE);
        FetchAsGooglePa.Apks.Fetch fetch = FetchAsGoogleClient.createStub().apks().fetch(request);
        return (Operation)fetch.execute();
    }

    private Operation getFetchResult(String fetchToken) throws IOException {
        FetchAsGooglePa.Operations.Get get = FetchAsGoogleClient.createStub().operations().get(fetchToken);
        return (Operation)get.execute();
    }

    private static class FetchAsGoogleHttpRequestInitializer
    implements HttpExecuteInterceptor,
    HttpRequestInitializer {
        private final Credential access;

        public FetchAsGoogleHttpRequestInitializer(Credential access) {
            this.access = access;
        }

        public void initialize(HttpRequest request) throws IOException {
            this.access.initialize(request);
            request.setInterceptor((HttpExecuteInterceptor)this);
        }

        public void intercept(HttpRequest request) throws IOException {
            this.access.intercept(request);
        }
    }

    public static class FetchAsGoogleException
    extends Exception {
        ErrorCode myErrorCode;

        public FetchAsGoogleException(String message, ErrorCode code) {
            super(message);
            this.myErrorCode = code;
        }

        public ErrorCode getErrorCode() {
            return this.myErrorCode;
        }

        public static enum ErrorCode {
            NO_CREDENTIAL,
            SERVER_ERROR,
            GENERIC_ERROR;

        }
    }
}

