/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.api;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.dsl.dependencies.Dependencies;
import com.android.tools.idea.gradle.dsl.dependencies.ExternalDependencySpec;
import com.android.tools.idea.gradle.dsl.dependencies.external.ExternalDependency;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.google.appindexing.api.StatementFilter;
import com.google.appindexing.util.DeepLinkUtils;
import com.google.appindexing.util.ManifestUtils;
import com.google.common.base.CharMatcher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiImportStatement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlComment;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.siyeh.ig.psiutils.ImportUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ApiCreator {
    private static final String COMPILE_GMS_GROUP = "com.google.android.gms";
    private static final String COMPILE_APPINDEXING = "play-services-appindexing";
    private static final String MINIMUM_VERSION = "8.1.0";
    private static final String TAG_METADATA = "meta-data";
    private static final String ATTR_NAME_METADATA_GMS = "com.google.android.gms.version";
    private static final String ATTR_VALUE_METADATA_GMS = "@integer/google_play_services_version";
    private static final String CLASS_ACTION = "Action";
    private static final String CLASS_APP_INDEX = "AppIndex";
    private static final String CLASS_GOOGLE_API_CLIENT = "GoogleApiClient";
    private static final String CLASS_ACTION_FULL = "com.google.android.gms.appindexing.Action";
    private static final String CLASS_APP_INDEX_FULL = "com.google.android.gms.appindexing.AppIndex";
    private static final String CLASS_GOOGLE_API_CLIENT_FULL = "com.google.android.gms.common.api.GoogleApiClient";
    private static final List<String> SIGNATURE_ON_CREATE = Lists.newArrayList((Object[])new String[]{"android.os.Bundle"});
    private static final List<String> SIGNATURE_ON_START = Lists.newArrayList();
    private static final List<String> SIGNATURE_ON_STOP = Lists.newArrayList();
    private static final String ON_CREATE_FORMAT = "@Override\nprotected void onCreate(android.os.Bundle savedInstanceState) {\n  super.onCreate(savedInstanceState);\n  \n  // ATTENTION: This was auto-generated to implement the App Indexing API.\n  // See https://g.co/AppIndexing/AndroidStudio for more information.\n  %1$s = new %2$s.Builder(this).addApi(%3$s.API).build();\n}";
    private static final String ON_START_FORMAT = "@Override\npublic void onStart(){\n  super.onStart();\n  \n  // ATTENTION: This was auto-generated to implement the App Indexing API.\n  // See https://g.co/AppIndexing/AndroidStudio for more information.\n  %1$s.connect();\n  %3$s\n  %4$s.AppIndexApi.start(%1$s, %2$s);\n}";
    private static final String ON_STOP_FORMAT = "@Override\npublic void onStop() {\n  super.onStop();\n  \n  // ATTENTION: This was auto-generated to implement the App Indexing API.\n  // See https://g.co/AppIndexing/AndroidStudio for more information.\n  %3$s\n  %4$s.AppIndexApi.end(%1$s, %2$s);\n  %1$s.disconnect();\n}";
    private static final String ACTION_FORMAT = "%6$s %1$s = %6$s.newAction(\n    %6$s.TYPE_VIEW, // TODO: choose an action type.\n    \"%2$s Page\", // TODO: Define a title for the content shown.\n    // TODO: If you have web page content that matches this app activity's content,\n    // make sure this auto-generated web page URL is correct.\n    // Otherwise, set the URL to null.\n    android.net.Uri.parse(\"http://%4$s\"), \n    // TODO: Make sure this auto-generated app deep link URI is correct.\n    android.net.Uri.parse(\"android-app://%3$s/%5$s/%4$s\")\n);";
    private static final String CLIENT_FORMAT = "%1$s = new %2$s.Builder(this).addApi(%3$s.API).build();";
    private static final String BUILDER_APPINDEXAPI = ".addApi(%s.API)";
    private static final String APP_INDEXING_START = "%3$s.AppIndexApi.start(%1$s,%2$s);";
    private static final String APP_INDEXING_END = "%3$s.AppIndexApi.end(%1$s,%2$s);";
    private static final String APP_INDEXING_START_HALF = "AppIndexApi.start(%1$s,";
    private static final String APP_INDEXING_END_HALF = "AppIndexApi.end(%1$s,";
    private static final String APP_INDEXING_VIEW = "AppIndexApi.view(%1$s,";
    private static final String APP_INDEXING_VIEWEND = "AppIndexApi.viewEnd(%1$s,";
    private static final List<String> COMMENT_BUILDER_APPINDEXAPI = Lists.newArrayList((Object[])new String[]{"// ATTENTION: This \"addApi(AppIndex.API)\"was auto-generated to implement the App Indexing API.", "// See https://g.co/AppIndexing/AndroidStudio for more information."});
    private static final List<String> COMMENT_IN_JAVA = Lists.newArrayList((Object[])new String[]{"// ATTENTION: This was auto-generated to implement the App Indexing API.", "// See https://g.co/AppIndexing/AndroidStudio for more information."});
    private static final String COMMENT_FOR_FIELD = "/**\n * ATTENTION: This %1$swas auto-generated to implement the App Indexing API.\n * See https://g.co/AppIndexing/AndroidStudio for more information.\n */";
    private static final String COMMENT_IN_MANIFEST = "<!-- ATTENTION: This was auto-generated to add Google Play services to your project for\n     App Indexing.  See https://g.co/AppIndexing/AndroidStudio for more information. -->";
    private Project myProject = null;
    private Module myModule = null;
    private PsiFile myFile = null;
    private PsiClass myActivity = null;
    private PsiElementFactory myFactory = null;
    private CodeStyleManager myCodeStyleManager = null;
    private PsiCodeBlock myOnCreate = null;
    private PsiCodeBlock myOnStart = null;
    private PsiCodeBlock myOnStop = null;
    private List<PsiStatement> myStartStatements = Lists.newArrayList();
    private List<PsiStatement> myEndStatements = Lists.newArrayList();
    private List<PsiStatement> myViewStatements = Lists.newArrayList();
    private List<PsiStatement> myViewEndStatements = Lists.newArrayList();
    private String myHighestGmsLibVersion = null;
    private String myAppIndexingLibVersion = null;
    private Map<String, String> myImportClasses = Maps.newHashMap();

    public ApiCreator(Project project, Editor editor, PsiFile file) {
        PsiElement element;
        this.myProject = project;
        this.myFile = file;
        this.myModule = ModuleUtilCore.findModuleForFile((VirtualFile)this.myFile.getVirtualFile(), (Project)this.myProject);
        if (this.myFile instanceof PsiJavaFile && (element = this.myFile.findElementAt(editor.getCaretModel().getOffset())) != null) {
            this.myActivity = ApiCreator.getSurroundingInheritingClass(element, "android.app.Activity");
            if (this.myActivity != null) {
                this.myOnCreate = ApiCreator.getMethodBodyByName("onCreate", SIGNATURE_ON_CREATE, this.myActivity);
                this.myOnStart = ApiCreator.getMethodBodyByName("onStart", SIGNATURE_ON_START, this.myActivity);
                this.myOnStop = ApiCreator.getMethodBodyByName("onStop", SIGNATURE_ON_STOP, this.myActivity);
                if (this.myOnStart != null) {
                    this.myStartStatements = StatementFilter.filterCodeBlock("AppIndex.AppIndexApi.start", this.myOnStart);
                    this.myViewStatements = StatementFilter.filterCodeBlock("AppIndex.AppIndexApi.view", this.myOnStart);
                }
                if (this.myOnStop != null) {
                    this.myEndStatements = StatementFilter.filterCodeBlock("AppIndex.AppIndexApi.end", this.myOnStop);
                    this.myViewEndStatements = StatementFilter.filterCodeBlock("AppIndex.AppIndexApi.viewEnd", this.myOnStop);
                }
            }
        }
        this.myFactory = (PsiElementFactory)JVMElementFactories.getFactory((Language)JavaLanguage.INSTANCE, (Project)this.myProject);
        this.myCodeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
        this.myImportClasses.put(CLASS_ACTION, CLASS_ACTION_FULL);
        this.myImportClasses.put(CLASS_APP_INDEX, CLASS_APP_INDEX_FULL);
        this.myImportClasses.put(CLASS_GOOGLE_API_CLIENT, CLASS_GOOGLE_API_CLIENT_FULL);
    }

    void setGmsLibVersion(String version) {
        this.myHighestGmsLibVersion = version;
        this.myAppIndexingLibVersion = version;
    }

    public static boolean eligibleForInsertingAppIndexingApiCode(Editor editor, PsiFile file) {
        if (!(file instanceof PsiJavaFile)) {
            return false;
        }
        PsiElement element = file.findElementAt(editor.getCaretModel().getOffset());
        if (element == null) {
            return false;
        }
        PsiClass activity = ApiCreator.getSurroundingInheritingClass(element, "android.app.Activity");
        if (activity == null) {
            return false;
        }
        PsiCodeBlock onStart = ApiCreator.getMethodBodyByName("onStart", SIGNATURE_ON_START, activity);
        if (onStart == null) {
            return true;
        }
        PsiCodeBlock onStop = ApiCreator.getMethodBodyByName("onStop", SIGNATURE_ON_STOP, activity);
        if (onStop == null) {
            return true;
        }
        List<PsiStatement> startStatements = StatementFilter.filterCodeBlock("AppIndexApi.start", onStart);
        List<PsiStatement> viewStatements = StatementFilter.filterCodeBlock("AppIndexApi.view", onStart);
        if (startStatements.isEmpty() && viewStatements.isEmpty()) {
            return true;
        }
        List<PsiStatement> endStatements = StatementFilter.filterCodeBlock("AppIndexApi.end", onStop);
        List<PsiStatement> viewEndStatements = StatementFilter.filterCodeBlock("AppIndexApi.viewEnd", onStop);
        return endStatements.isEmpty() && viewEndStatements.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertAppIndexingApiCodeForActivity() {
        boolean needGradleSync = false;
        try {
            if (this.myModule == null || this.myActivity == null || this.myFactory == null || this.myCodeStyleManager == null) {
                Logger.getInstance(ApiCreator.class).info("Unable to generate App Indexing API code.");
                return;
            }
            this.getGmsDependencyVersion();
            needGradleSync = this.insertGmsCompileDependencyInGradleIfNeeded();
            XmlFile manifestPsiFile = ManifestUtils.getAndroidManifestPsi(this.myModule);
            if (manifestPsiFile == null) {
                Logger.getInstance(ApiCreator.class).info("AndroidManifest.xml not found.");
                return;
            }
            this.insertGmsVersionTagInManifestIfNeeded(manifestPsiFile);
            this.insertAppIndexingApiCodeInJavaFile(this.getDeepLinkOfActivity(), !needGradleSync);
        }
        catch (ApiCreatorException e) {
            e.printStackTrace();
        }
        finally {
            if (needGradleSync) {
                GradleProjectImporter.getInstance().requestProjectSync(this.myProject, null);
            }
        }
    }

    private void getGmsDependencyVersion() throws ApiCreatorException {
        AndroidGradleModel model = AndroidGradleModel.get((Module)this.myModule);
        if (model == null) {
            throw new ApiCreatorException("AndroidGradleModel not found.");
        }
        AndroidArtifact artifact = model.getMainArtifact();
        Collection libraries = artifact.getDependencies().getLibraries();
        for (AndroidLibrary library : libraries) {
            this.getDependencyVersionFromAndroidLibrary(library);
        }
    }

    private void getDependencyVersionFromAndroidLibrary(AndroidLibrary library) {
        MavenCoordinates coordinates = library.getResolvedCoordinates();
        if (coordinates != null && coordinates.getGroupId().equals(COMPILE_GMS_GROUP)) {
            String version = coordinates.getVersion();
            if (coordinates.getArtifactId().equals(COMPILE_APPINDEXING)) {
                this.myAppIndexingLibVersion = version;
            }
            if (this.myHighestGmsLibVersion == null || ApiCreator.compareVersion(version, this.myHighestGmsLibVersion) > 0) {
                this.myHighestGmsLibVersion = version;
            }
        }
        for (AndroidLibrary dependency : library.getLibraryDependencies()) {
            this.getDependencyVersionFromAndroidLibrary(dependency);
        }
    }

    boolean insertGmsCompileDependencyInGradleIfNeeded() throws ApiCreatorException {
        GradleBuildModel buildModel = GradleBuildModel.get((Module)this.myModule);
        if (buildModel == null) {
            throw new ApiCreatorException("Build model not found.");
        }
        Dependencies dependencies = buildModel.dependencies();
        String versionToUse = MINIMUM_VERSION;
        if (this.myHighestGmsLibVersion != null && ApiCreator.compareVersion(this.myHighestGmsLibVersion, MINIMUM_VERSION) > 0) {
            versionToUse = this.myHighestGmsLibVersion;
        }
        boolean gradleChange = false;
        if (this.myAppIndexingLibVersion == null) {
            ExternalDependencySpec newDependency = new ExternalDependencySpec(COMPILE_APPINDEXING, COMPILE_GMS_GROUP, versionToUse);
            dependencies = buildModel.dependencies();
            dependencies.add("compile", newDependency);
            dependencies.applyChanges();
            gradleChange = true;
        }
        if (this.myHighestGmsLibVersion != null && ApiCreator.compareVersion(this.myHighestGmsLibVersion, versionToUse) < 0) {
            ImmutableList dependencyList = dependencies.external();
            for (ExternalDependency dependency : dependencyList) {
                String group = dependency.group();
                if (group == null || !group.equals(COMPILE_GMS_GROUP)) continue;
                dependency.version(versionToUse);
                dependency.applyChanges();
                gradleChange = true;
            }
        }
        return gradleChange;
    }

    void insertGmsVersionTagInManifestIfNeeded(XmlFile manifestPsiFile) {
        XmlTag root = manifestPsiFile.getRootTag();
        if (root != null) {
            List<XmlTag> applications = ManifestUtils.searchXmlTagsByName(root, "application");
            for (XmlTag application : applications) {
                if (ApiCreator.getGmsTag(application) != null) continue;
                XmlTag gms = application.createChildTag(TAG_METADATA, null, null, false);
                gms = application.addSubTag(gms, false);
                gms.setAttribute("name", "http://schemas.android.com/apk/res/android", ATTR_NAME_METADATA_GMS);
                gms.setAttribute("value", "http://schemas.android.com/apk/res/android", ATTR_VALUE_METADATA_GMS);
                XmlTag GmsTag = ApiCreator.getGmsTag(application);
                XmlComment comment = this.createXmlComment(COMMENT_IN_MANIFEST);
                if (comment == null || GmsTag == null) continue;
                application.addBefore((PsiElement)comment, (PsiElement)GmsTag);
            }
            this.unlockFromPsiOperation((PsiFile)manifestPsiFile);
        }
    }

    void insertAppIndexingApiCodeInJavaFile(String deepLink, boolean withAppIndexingDependency) {
        List<String> clientNames;
        PsiStatement statementAppIndexApi;
        this.insertImportStatements(withAppIndexingDependency);
        String clientName = null;
        String clientNameCandidate = null;
        List<PsiStatement> statementsAppIndexApi = this.getAppIndexApiStatement();
        Iterator<PsiStatement> i$ = statementsAppIndexApi.iterator();
        while (i$.hasNext() && (clientNameCandidate = ApiCreator.getClientInAppIndexingApi(statementAppIndexApi = i$.next())) == null) {
        }
        if (clientNameCandidate == null && !(clientNames = this.getFieldNameByType(CLASS_GOOGLE_API_CLIENT)).isEmpty()) {
            clientNameCandidate = clientNames.get(0);
        }
        if (clientNameCandidate != null) {
            PsiField clientField = this.getFieldByName(clientNameCandidate);
            PsiStatement clientInitStatement = null;
            if (clientField != null && !clientField.hasInitializer()) {
                clientInitStatement = this.getClientInitStatements(clientNameCandidate);
            }
            if (clientField != null) {
                boolean adjustmentSucceed = false;
                if (clientField.hasInitializer()) {
                    adjustmentSucceed = this.adjustClientFieldInitializerIfNeeded(clientField);
                } else if (clientInitStatement != null) {
                    adjustmentSucceed = this.adjustClientInitStatementIfNeeded(clientInitStatement);
                }
                if (adjustmentSucceed) {
                    clientName = clientNameCandidate;
                }
            }
        }
        if (clientName == null) {
            clientName = this.createGoogleApiClientField();
        }
        String actionName = this.getUnusedName("viewAction", VariableKind.LOCAL_VARIABLE);
        String actionStatement = this.getActionStatement(deepLink, actionName);
        this.addOrMergeOnStart(clientName, actionName, actionStatement);
        this.addOrMergeOnStop(clientName, actionName, actionStatement);
        JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)this.myActivity);
        this.unlockFromPsiOperation(this.myFile);
    }

    private void insertImportStatements(boolean withAppIndexingDependency) {
        if (!withAppIndexingDependency) {
            for (Map.Entry<String, String> className : this.myImportClasses.entrySet()) {
                if (ImportUtils.hasOnDemandImportConflict((String)className.getValue(), (PsiElement)this.myActivity) || ImportUtils.hasExactImportConflict((String)className.getValue(), (PsiJavaFile)((PsiJavaFile)this.myFile))) continue;
                this.insertSingleImportIfNeeded(className.getValue());
                className.setValue(className.getKey());
            }
        }
    }

    private List<PsiStatement> getAppIndexApiStatement() {
        ArrayList result = Lists.newArrayList(this.myStartStatements);
        result.addAll(this.myViewStatements);
        if (!result.isEmpty()) {
            return result;
        }
        result.addAll(this.myEndStatements);
        result.addAll(this.myViewEndStatements);
        return result;
    }

    private PsiStatement getClientInitStatements(String clientName) {
        if (this.myOnCreate != null) {
            List<PsiStatement> statements = StatementFilter.filterCodeBlock(".build()", this.myOnCreate);
            for (PsiStatement statement : statements) {
                PsiType statementType;
                if (!(statement instanceof PsiExpressionStatement) || (statementType = ((PsiExpressionStatement)statement).getExpression().getType()) == null || !statementType.getPresentableText().equals(CLASS_GOOGLE_API_CLIENT) || !CharMatcher.WHITESPACE.removeFrom((CharSequence)statement.getText()).startsWith(clientName + "=")) continue;
                return statement;
            }
        }
        return null;
    }

    private boolean adjustClientFieldInitializerIfNeeded(PsiField clientField) {
        String oldInitializerText;
        String newInitializerText;
        PsiExpression clientInitializer = clientField.getInitializer();
        if (clientInitializer != null && (newInitializerText = this.generateApiClientInitializeString(oldInitializerText = clientInitializer.getText())) != null) {
            if (!newInitializerText.equals(oldInitializerText)) {
                clientField.setInitializer(this.myFactory.createExpressionFromText(newInitializerText, null));
                String commentText = String.format(COMMENT_FOR_FIELD, "\"addApi(AppIndex.API)\" ");
                this.myActivity.addBefore((PsiElement)this.myFactory.createCommentFromText(commentText, null), (PsiElement)clientField);
            }
            return true;
        }
        return false;
    }

    private boolean adjustClientInitStatementIfNeeded(PsiStatement statement) {
        String oldText = statement.getText();
        String newText = this.generateApiClientInitializeString(oldText);
        if (newText != null) {
            PsiElement newStatement = statement.replace((PsiElement)this.myFactory.createStatementFromText(newText, null));
            if (!newText.equals(oldText)) {
                this.addCommentsBefore(COMMENT_BUILDER_APPINDEXAPI, (PsiElement)this.myOnCreate, newStatement);
            }
            return true;
        }
        return false;
    }

    private String createGoogleApiClientField() {
        String clientName = this.getUnusedName("client", VariableKind.FIELD);
        PsiClassType type = this.myFactory.createTypeByFQClassName(this.myImportClasses.get(CLASS_GOOGLE_API_CLIENT));
        PsiField clientField = (PsiField)this.myActivity.add((PsiElement)this.myFactory.createField(clientName, (PsiType)type));
        this.myCodeStyleManager.reformat((PsiElement)this.myActivity);
        String comment = String.format(COMMENT_FOR_FIELD, "");
        this.myActivity.addBefore((PsiElement)this.myFactory.createCommentFromText(comment, null), (PsiElement)clientField);
        this.generateGoogleApiClientInitializationInOnCreate(clientName);
        return clientName;
    }

    private void generateGoogleApiClientInitializationInOnCreate(String clientName) {
        if (this.myOnCreate == null) {
            String onCreateMethod = String.format(ON_CREATE_FORMAT, clientName, this.myImportClasses.get(CLASS_GOOGLE_API_CLIENT), this.myImportClasses.get(CLASS_APP_INDEX));
            PsiMethod newOnCreate = this.myFactory.createMethodFromText(onCreateMethod, null);
            this.myActivity.add((PsiElement)newOnCreate);
        } else {
            String initText = String.format(CLIENT_FORMAT, clientName, this.myImportClasses.get(CLASS_GOOGLE_API_CLIENT), this.myImportClasses.get(CLASS_APP_INDEX));
            PsiElement initStatement = this.myOnCreate.add((PsiElement)this.myFactory.createStatementFromText(initText, null));
            this.addCommentsBefore(COMMENT_IN_JAVA, (PsiElement)this.myOnCreate, initStatement);
        }
    }

    private void addOrMergeOnStart(String clientName, String actionName, String actionInitText) {
        if (this.myOnStart == null) {
            String onStartMethod = String.format(ON_START_FORMAT, clientName, actionName, actionInitText, this.myImportClasses.get(CLASS_APP_INDEX));
            this.myActivity.add((PsiElement)this.myFactory.createMethodFromText(onStartMethod, null));
        } else {
            String connectCall = clientName + ".connect();";
            List<PsiStatement> connectStatements = StatementFilter.filterCodeBlock(connectCall, this.myOnStart);
            if (connectStatements.isEmpty()) {
                PsiStatement connectStatement = this.myFactory.createStatementFromText(connectCall, null);
                List<PsiStatement> superOnStartStatements = StatementFilter.filterCodeBlock("super.onStart();", this.myOnStart);
                if (!superOnStartStatements.isEmpty()) {
                    connectStatement = (PsiStatement)this.myOnStart.addAfter((PsiElement)connectStatement, (PsiElement)superOnStartStatements.get(0));
                    this.addCommentsBefore(COMMENT_IN_JAVA, (PsiElement)this.myOnStart, (PsiElement)connectStatement);
                } else {
                    connectStatement = (PsiStatement)this.myOnStart.addAfter((PsiElement)connectStatement, this.myOnStart.getFirstBodyElement());
                    this.addCommentsBefore(COMMENT_IN_JAVA, (PsiElement)this.myOnStart, (PsiElement)connectStatement);
                }
            }
            String startTextHalf = String.format(APP_INDEXING_START_HALF, clientName);
            this.myStartStatements = StatementFilter.filterStatements(startTextHalf, this.myStartStatements);
            String viewText = String.format(APP_INDEXING_VIEW, clientName);
            this.myViewStatements = StatementFilter.filterStatements(viewText, this.myViewStatements);
            if (this.myStartStatements.isEmpty() && this.myViewStatements.isEmpty()) {
                PsiElement actionStatement = this.myOnStart.add((PsiElement)this.myFactory.createStatementFromText(actionInitText, null));
                this.addCommentsBefore(COMMENT_IN_JAVA, (PsiElement)this.myOnStart, actionStatement);
                String startText = String.format(APP_INDEXING_START, clientName, actionName, this.myImportClasses.get(CLASS_APP_INDEX));
                this.myOnStart.add((PsiElement)this.myFactory.createStatementFromText(startText, null));
            }
        }
    }

    private void addOrMergeOnStop(String clientName, String actionName, String actionInitText) {
        if (this.myOnStop == null) {
            String onStopMethod = String.format(ON_STOP_FORMAT, clientName, actionName, actionInitText, this.myImportClasses.get(CLASS_APP_INDEX));
            this.myActivity.add((PsiElement)this.myFactory.createMethodFromText(onStopMethod, null));
        } else {
            String disconnectCall = clientName + ".disconnect();";
            List<PsiStatement> disconnectStatements = StatementFilter.filterCodeBlock(disconnectCall, this.myOnStop);
            if (disconnectStatements.isEmpty()) {
                PsiElement disconnectStatement = this.myOnStop.add((PsiElement)this.myFactory.createStatementFromText(disconnectCall, null));
                this.addCommentsBefore(COMMENT_IN_JAVA, (PsiElement)this.myOnStop, disconnectStatement);
            }
            String endTextHalf = String.format(APP_INDEXING_END_HALF, clientName);
            this.myEndStatements = StatementFilter.filterStatements(endTextHalf, this.myEndStatements);
            String viewEndText = String.format(APP_INDEXING_VIEWEND, clientName);
            this.myViewEndStatements = StatementFilter.filterStatements(viewEndText, this.myViewEndStatements);
            if (this.myEndStatements.isEmpty() && this.myViewEndStatements.isEmpty()) {
                String endText = String.format(APP_INDEXING_END, clientName, actionName, this.myImportClasses.get(CLASS_APP_INDEX));
                PsiStatement endStatement = this.myFactory.createStatementFromText(endText, null);
                List<PsiStatement> superOnStopStatements = StatementFilter.filterCodeBlock("super.onStop();", this.myOnStop);
                if (!superOnStopStatements.isEmpty()) {
                    this.myOnStop.addAfter((PsiElement)endStatement, (PsiElement)superOnStopStatements.get(0));
                    PsiStatement actionStatement = this.myFactory.createStatementFromText(actionInitText, null);
                    actionStatement = (PsiStatement)this.myOnStop.addAfter((PsiElement)actionStatement, (PsiElement)superOnStopStatements.get(0));
                    this.addCommentsBefore(COMMENT_IN_JAVA, (PsiElement)this.myOnStop, (PsiElement)actionStatement);
                } else {
                    endStatement = (PsiStatement)this.myOnStop.addAfter((PsiElement)endStatement, this.myOnStop.getFirstBodyElement());
                    PsiStatement actionStatement = this.myFactory.createStatementFromText(actionInitText, null);
                    actionStatement = (PsiStatement)this.myOnStop.addBefore((PsiElement)actionStatement, (PsiElement)endStatement);
                    this.addCommentsBefore(COMMENT_IN_JAVA, (PsiElement)this.myOnStop, (PsiElement)actionStatement);
                }
            }
        }
    }

    private static int compareVersion(String version1, String version2) {
        GradleCoordinate coordinate1 = GradleCoordinate.parseVersionOnly((String)version1);
        GradleCoordinate coordinate2 = GradleCoordinate.parseVersionOnly((String)version2);
        return GradleCoordinate.COMPARE_PLUS_HIGHER.compare(coordinate1, coordinate2);
    }

    private static XmlTag getGmsTag(XmlTag application) {
        XmlTag[] children;
        for (XmlTag child : children = application.getSubTags()) {
            String tagName;
            if (!child.getName().equalsIgnoreCase(TAG_METADATA) || (tagName = child.getAttributeValue("name", "http://schemas.android.com/apk/res/android")) == null || !tagName.equals(ATTR_NAME_METADATA_GMS)) continue;
            return child;
        }
        return null;
    }

    private static String getClientInAppIndexingApi(PsiStatement statement) {
        block3: {
            PsiElement[] children;
            block2: {
                PsiElement[] children2;
                if (!(statement instanceof PsiExpressionStatement)) break block2;
                for (PsiElement child : children2 = statement.getChildren()) {
                    PsiExpression[] args;
                    String clientName;
                    if (!(child instanceof PsiMethodCallExpression)) continue;
                    String callExpression = ((PsiMethodCallExpression)child).getMethodExpression().getText();
                    callExpression = CharMatcher.WHITESPACE.removeFrom((CharSequence)callExpression);
                    PsiType[] argsType = ((PsiMethodCallExpression)child).getArgumentList().getExpressionTypes();
                    if (!callExpression.startsWith("AppIndex.AppIndexApi.") && !callExpression.startsWith("AppIndexApi") && !callExpression.startsWith(CLASS_APP_INDEX_FULL) || argsType.length != 2 && argsType.length != 3 && argsType.length != 6 || argsType[0] == null || (clientName = (args = ((PsiMethodCallExpression)child).getArgumentList().getExpressions())[0].getText()) == null) continue;
                    return clientName;
                }
                break block3;
            }
            if (!(statement instanceof PsiDeclarationStatement)) break block3;
            for (PsiElement child : children = ((PsiDeclarationStatement)statement).getDeclaredElements()) {
                String clientName;
                PsiElement[] initChildren;
                PsiExpression initializer;
                if (!(child instanceof PsiVariable) || (initializer = ((PsiVariable)child).getInitializer()) == null || (initChildren = initializer.getChildren()).length != 2 || !(initChildren[0] instanceof PsiReferenceExpression) || !(initChildren[1] instanceof PsiExpressionList)) continue;
                String referenceExpression = CharMatcher.WHITESPACE.removeFrom((CharSequence)initChildren[0].getText());
                PsiExpression[] args = ((PsiExpressionList)initChildren[1]).getExpressions();
                if (!referenceExpression.startsWith("AppIndex.AppIndexApi.") && !referenceExpression.startsWith("AppIndexApi.") && !referenceExpression.startsWith(CLASS_APP_INDEX_FULL) || args.length != 2 && args.length != 3 && args.length != 6 || args[0].getType() == null || (clientName = args[0].getText()) == null) continue;
                return clientName;
            }
        }
        return null;
    }

    private String getUnusedName(String name, VariableKind kind) {
        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)this.myProject);
        name = javaCodeStyleManager.suggestVariableName((VariableKind)kind, (String)name, null, null).names[0];
        Set<String> usedName = this.getUsedVariableName();
        String unusedName = name;
        int suffix = 2;
        while (usedName.contains(unusedName)) {
            unusedName = name + suffix;
            ++suffix;
        }
        return unusedName;
    }

    private String generateApiClientInitializeString(String statementText) {
        int splitPoint = statementText.lastIndexOf(".build()");
        if (!statementText.contains(String.format(BUILDER_APPINDEXAPI, CLASS_APP_INDEX_FULL)) && !statementText.contains(String.format(BUILDER_APPINDEXAPI, CLASS_APP_INDEX)) && splitPoint != -1) {
            return statementText.substring(0, splitPoint) + String.format(BUILDER_APPINDEXAPI, this.myImportClasses.get(CLASS_APP_INDEX)) + statementText.substring(splitPoint);
        }
        if (splitPoint != -1) {
            return statementText;
        }
        return null;
    }

    String getActionStatement(String deepLink, String actionName) {
        String pageName = this.myActivity.getName();
        if (pageName.endsWith("Activity")) {
            pageName = pageName.substring(0, pageName.length() - 8);
        }
        String packageName = ((PsiJavaFile)this.myFile).getPackageName();
        String scheme = deepLink == null ? "http" : deepLink.substring(0, deepLink.indexOf("://"));
        String hostAndPath = ApiCreator.getHostAndPathOfDeepLink(deepLink);
        return String.format(ACTION_FORMAT, actionName, pageName, packageName, hostAndPath, scheme, this.myImportClasses.get(CLASS_ACTION));
    }

    private static String getHostAndPathOfDeepLink(String deepLink) {
        String hostAndPath = "host/path";
        if (deepLink != null) {
            if (!deepLink.substring(deepLink.indexOf("://") + 3).isEmpty()) {
                hostAndPath = deepLink.substring(deepLink.indexOf("://") + 3);
            }
            if (!hostAndPath.contains("/")) {
                hostAndPath = hostAndPath + "/path";
            }
        }
        return hostAndPath;
    }

    String getDeepLinkOfActivity() {
        XmlFile manifest = ManifestUtils.getAndroidManifestPsi(this.myModule);
        if (manifest != null && manifest.getRootTag() != null) {
            List<XmlTag> activityTags = ManifestUtils.searchXmlTagsByName(manifest.getRootTag(), "activity");
            for (XmlTag activityTag : activityTags) {
                List<String> deepLinks;
                String activityName = activityTag.getAttributeValue("name", "http://schemas.android.com/apk/res/android");
                if (activityName == null || !activityName.equals("." + this.myActivity.getName()) || (deepLinks = DeepLinkUtils.getAllDeepLinks(activityTag)).isEmpty()) continue;
                return deepLinks.get(0);
            }
        }
        return null;
    }

    private XmlComment createXmlComment(String text) {
        XmlElementFactory xmlElementFactory = XmlElementFactory.getInstance((Project)this.myProject);
        XmlTag commentElement = xmlElementFactory.createTagFromText((CharSequence)("<foo>" + text + "</foo>"), (Language)XMLLanguage.INSTANCE);
        return (XmlComment)PsiTreeUtil.getChildOfType((PsiElement)commentElement, XmlComment.class);
    }

    private void addCommentsBefore(List<String> texts, PsiElement element, PsiElement anchor) {
        this.myCodeStyleManager.reformat(element);
        for (String text : texts) {
            element.addBefore((PsiElement)this.myFactory.createCommentFromText(text, null), anchor);
            this.myCodeStyleManager.reformat(element);
        }
    }

    private void unlockFromPsiOperation(PsiFile file) {
        Document doc = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
        if (doc != null) {
            PsiDocumentManager.getInstance((Project)this.myProject).doPostponedOperationsAndUnblockDocument(doc);
        }
    }

    private static PsiClass getSurroundingInheritingClass(PsiElement element, String inheritedClass) {
        while (element != null) {
            PsiClass psiClass;
            if (element instanceof PsiClass && InheritanceUtil.isInheritor((PsiClass)(psiClass = (PsiClass)element), (String)inheritedClass)) {
                return psiClass;
            }
            if (element instanceof PsiFile) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    private static PsiCodeBlock getMethodBodyByName(String name, List<String> parametersTypeName, PsiClass psiClass) {
        PsiMethod[] psiMethods;
        for (PsiMethod psiMethod : psiMethods = psiClass.findMethodsByName(name, false)) {
            PsiType[] types = psiMethod.getSignature(PsiSubstitutor.EMPTY).getParameterTypes();
            if (types.length != parametersTypeName.size()) continue;
            boolean correctSignature = true;
            for (int i = 0; i < types.length; ++i) {
                if (types[i].getCanonicalText().equals(parametersTypeName.get(i))) continue;
                correctSignature = false;
                break;
            }
            if (!correctSignature) continue;
            return psiMethod.getBody();
        }
        return null;
    }

    private List<String> getFieldNameByType(String typeName) {
        PsiField[] psiFields;
        ArrayList result = Lists.newArrayList();
        for (PsiField psiField : psiFields = this.myActivity.getFields()) {
            if (!psiField.getType().getPresentableText().equals(typeName)) continue;
            result.add(psiField.getName());
        }
        return result;
    }

    private PsiField getFieldByName(String name) {
        PsiField[] psiFields;
        for (PsiField psiField : psiFields = this.myActivity.getFields()) {
            if (!psiField.getName().equals(name)) continue;
            return psiField;
        }
        return null;
    }

    private void insertSingleImportIfNeeded(String className) {
        PsiImportList importList = ((PsiJavaFile)this.myFile).getImportList();
        if (importList != null && !ApiCreator.hasImportStatement(importList, className)) {
            String dummyFileName = "_Dummy_" + className + "_." + JavaFileType.INSTANCE.getDefaultExtension();
            PsiJavaFile aFile = (PsiJavaFile)PsiFileFactory.getInstance((Project)this.myProject).createFileFromText(dummyFileName, (FileType)JavaFileType.INSTANCE, (CharSequence)("import " + className + ";"));
            PsiImportList dummyImportList = aFile.getImportList();
            if (dummyImportList != null) {
                PsiImportStatement[] statements = dummyImportList.getImportStatements();
                PsiImportStatement statement = (PsiImportStatement)this.myCodeStyleManager.reformat((PsiElement)statements[0]);
                importList.add((PsiElement)statement);
            }
        }
    }

    private static boolean hasImportStatement(PsiImportList importList, String className) {
        String packageName = className.substring(0, className.lastIndexOf(46));
        PsiImportStatement singleImport = importList.findSingleClassImportStatement(className);
        PsiImportStatement onDemandImport = importList.findOnDemandImportStatement(packageName);
        return singleImport != null || onDemandImport != null;
    }

    private Set<String> getUsedVariableName() {
        PsiMethod[] psiMethods;
        PsiField[] psiFields;
        HashSet usedNames = Sets.newHashSet();
        for (PsiField psiField : psiFields = this.myActivity.getFields()) {
            usedNames.add(psiField.getName());
        }
        for (PsiMethod psiMethod : psiMethods = this.myActivity.getMethods()) {
            PsiCodeBlock methodBody = psiMethod.getBody();
            if (methodBody == null) continue;
            List<PsiStatement> psiStatements = StatementFilter.filterCodeBlock("", methodBody);
            for (PsiStatement psiStatement : psiStatements) {
                PsiElement[] declaredElements;
                if (!(psiStatement instanceof PsiDeclarationStatement)) continue;
                for (PsiElement declaredElement : declaredElements = ((PsiDeclarationStatement)psiStatement).getDeclaredElements()) {
                    usedNames.add(((PsiLocalVariable)declaredElement).getName());
                }
            }
        }
        return usedNames;
    }

    static class ApiCreatorException
    extends Exception {
        public ApiCreatorException(String message) {
            super(message);
        }
    }
}

