/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.actions;

import com.android.tools.idea.stats.UsageTracker;
import com.google.appindexing.api.ApiCreator;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;

public class InsertApiCodeIntentionAction
extends AbstractIntentionAction {
    public String getText() {
        return "Insert App Indexing API Code";
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isAvailable(Project project, Editor editor, PsiFile file) {
        if (editor == null || file == null) {
            return false;
        }
        return ApiCreator.eligibleForInsertingAppIndexingApiCode(editor, file);
    }

    public void invoke(Project project, Editor editor, PsiFile file) {
        if (editor != null && file != null) {
            UsageTracker.getInstance().trackEvent("appIndexing", "apiCodeCreated", null, null);
            ApiCreator creator = new ApiCreator(project, editor, file);
            creator.insertAppIndexingApiCodeForActivity();
        }
    }
}

