/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ThrowableConvertor;
import java.io.IOException;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.plugins.github.api.GithubUser;
import org.jetbrains.plugins.github.ui.GithubLoginPanel;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubAuthDataHolder;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubLoginDialog
extends DialogWrapper {
    protected static final Logger LOG = GithubUtil.LOG;
    protected final GithubLoginPanel myGithubLoginPanel;
    protected final GithubSettings mySettings;
    protected final Project myProject;
    protected GithubAuthData myAuthData;

    public GithubLoginDialog(Project project, GithubAuthData oldAuthData) {
        super(project, true);
        this.myProject = project;
        this.myGithubLoginPanel = new GithubLoginPanel(this);
        this.myGithubLoginPanel.setHost(oldAuthData.getHost());
        this.myGithubLoginPanel.setAuthType(oldAuthData.getAuthType());
        GithubAuthData.BasicAuth basicAuth = oldAuthData.getBasicAuth();
        if (basicAuth != null) {
            this.myGithubLoginPanel.setLogin(basicAuth.getLogin());
        }
        this.mySettings = GithubSettings.getInstance();
        if (this.mySettings.isSavePasswordMakesSense()) {
            this.myGithubLoginPanel.setSavePasswordSelected(this.mySettings.isSavePassword());
        } else {
            this.myGithubLoginPanel.setSavePasswordVisibleEnabled(false);
        }
        this.setTitle("Login to GitHub");
        this.setOKButtonText("Login");
        this.init();
    }

    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction(), this.getHelpAction()};
    }

    protected JComponent createCenterPanel() {
        return this.myGithubLoginPanel.getPanel();
    }

    protected String getHelpId() {
        return "login_to_github";
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myGithubLoginPanel.getPreferableFocusComponent();
    }

    protected void doOKAction() {
        final GithubAuthDataHolder authHolder = new GithubAuthDataHolder(this.myGithubLoginPanel.getAuthData());
        try {
            GithubUtil.computeValueInModal(this.myProject, "Access to GitHub", new ThrowableConvertor<ProgressIndicator, GithubUser, IOException>(){

                public GithubUser convert(ProgressIndicator indicator) throws IOException {
                    return GithubUtil.checkAuthData(GithubLoginDialog.this.myProject, authHolder, indicator);
                }
            });
            this.myAuthData = authHolder.getAuthData();
            if (this.mySettings.isSavePasswordMakesSense()) {
                this.mySettings.setSavePassword(this.myGithubLoginPanel.isSavePasswordSelected());
            }
            super.doOKAction();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            this.setErrorText("Can't login: " + GithubUtil.getErrorTextFromException(e));
        }
    }

    public boolean isSavePasswordSelected() {
        return this.myGithubLoginPanel.isSavePasswordSelected();
    }

    public GithubAuthData getAuthData() {
        if (this.myAuthData == null) {
            throw new IllegalStateException("AuthData is not set");
        }
        return this.myAuthData;
    }

    public void clearErrors() {
        this.setErrorText(null);
    }
}

