/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.openapi.util.text.StringUtil;

public class GithubFullPath {
    private final String myUserName;
    private final String myRepositoryName;

    public GithubFullPath(String userName, String repositoryName) {
        this.myUserName = userName;
        this.myRepositoryName = repositoryName;
    }

    public String getUser() {
        return this.myUserName;
    }

    public String getRepository() {
        return this.myRepositoryName;
    }

    public String getFullName() {
        return this.myUserName + '/' + this.myRepositoryName;
    }

    public String toString() {
        return "'" + this.getFullName() + "'";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GithubFullPath that = (GithubFullPath)o;
        if (!StringUtil.equalsIgnoreCase((CharSequence)this.myRepositoryName, (CharSequence)that.myRepositoryName)) {
            return false;
        }
        return StringUtil.equalsIgnoreCase((CharSequence)this.myUserName, (CharSequence)that.myUserName);
    }

    public int hashCode() {
        int result = this.myUserName.hashCode();
        result = 31 * result + this.myRepositoryName.hashCode();
        return result;
    }
}

