/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.ssl.CertificateManager;
import java.awt.EventQueue;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.plugins.github.api.DataConstructor;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubErrorMessage;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubConfusingException;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.exceptions.GithubRateLimitExceededException;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.exceptions.GithubTwoFactorAuthenticationException;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubSettings;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;
import sun.security.validator.ValidatorException;

public class GithubConnection {
    private static final Logger LOG = GithubUtil.LOG;
    private static final HttpRequestInterceptor PREEMPTIVE_BASIC_AUTH = new PreemptiveBasicAuthInterceptor();
    private final String myHost;
    private final CloseableHttpClient myClient;
    private final boolean myReusable;
    private volatile HttpUriRequest myRequest;
    private volatile boolean myAborted;

    public GithubConnection(GithubAuthData auth) {
        this(auth, false);
    }

    public GithubConnection(GithubAuthData auth, boolean reusable) {
        this.myHost = auth.getHost();
        this.myClient = GithubConnection.createClient(auth);
        this.myReusable = reusable;
    }

    public JsonElement getRequest(String path, Header ... headers) throws IOException {
        return this.request(path, null, Arrays.asList(headers), HttpVerb.GET).getJsonElement();
    }

    public JsonElement postRequest(String path, String requestBody, Header ... headers) throws IOException {
        return this.request(path, requestBody, Arrays.asList(headers), HttpVerb.POST).getJsonElement();
    }

    public JsonElement patchRequest(String path, String requestBody, Header ... headers) throws IOException {
        return this.request(path, requestBody, Arrays.asList(headers), HttpVerb.PATCH).getJsonElement();
    }

    public JsonElement deleteRequest(String path, Header ... headers) throws IOException {
        return this.request(path, null, Arrays.asList(headers), HttpVerb.DELETE).getJsonElement();
    }

    public Header[] headRequest(String path, Header ... headers) throws IOException {
        return this.request(path, null, Arrays.asList(headers), HttpVerb.HEAD).getHeaders();
    }

    public void abort() {
        if (this.myAborted) {
            return;
        }
        this.myAborted = true;
        HttpUriRequest request = this.myRequest;
        if (request != null) {
            request.abort();
        }
    }

    public void close() throws IOException {
        this.myClient.close();
    }

    private static CloseableHttpClient createClient(GithubAuthData auth) {
        HttpClientBuilder builder = HttpClients.custom();
        return builder.setDefaultRequestConfig(GithubConnection.createRequestConfig(auth)).setDefaultConnectionConfig(GithubConnection.createConnectionConfig(auth)).setDefaultCredentialsProvider(GithubConnection.createCredentialsProvider(auth)).setDefaultHeaders(GithubConnection.createHeaders(auth)).addInterceptorFirst(PREEMPTIVE_BASIC_AUTH).setSslcontext(CertificateManager.getInstance().getSslContext()).setHostnameVerifier((X509HostnameVerifier)CertificateManager.HOSTNAME_VERIFIER).build();
    }

    private static RequestConfig createRequestConfig(GithubAuthData auth) {
        RequestConfig.Builder builder = RequestConfig.custom();
        int timeout = GithubSettings.getInstance().getConnectionTimeout();
        builder.setConnectTimeout(timeout).setSocketTimeout(timeout);
        if (auth.isUseProxy()) {
            HttpConfigurable.getInstance().setProxy(builder);
        }
        return builder.build();
    }

    private static ConnectionConfig createConnectionConfig(GithubAuthData auth) {
        return ConnectionConfig.custom().setCharset(Consts.UTF_8).build();
    }

    private static CredentialsProvider createCredentialsProvider(GithubAuthData auth) {
        BasicCredentialsProvider provider = new BasicCredentialsProvider();
        GithubAuthData.BasicAuth basicAuth = auth.getBasicAuth();
        if (basicAuth != null) {
            provider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(basicAuth.getLogin(), basicAuth.getPassword()));
        }
        if (auth.isUseProxy()) {
            HttpConfigurable.getInstance().setProxyCredentials((CredentialsProvider)provider);
        }
        return provider;
    }

    private static Collection<? extends Header> createHeaders(GithubAuthData auth) {
        GithubAuthData.BasicAuth basicAuth;
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        GithubAuthData.TokenAuth tokenAuth = auth.getTokenAuth();
        if (tokenAuth != null) {
            headers.add(new BasicHeader("Authorization", "token " + tokenAuth.getToken()));
        }
        if ((basicAuth = auth.getBasicAuth()) != null && basicAuth.getCode() != null) {
            headers.add(new BasicHeader("X-GitHub-OTP", basicAuth.getCode()));
        }
        return headers;
    }

    private ResponsePage request(String path, String requestBody, Collection<Header> headers, HttpVerb verb) throws IOException {
        if (this.myAborted) {
            throw new GithubOperationCanceledException();
        }
        if (EventQueue.isDispatchThread() && !ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.warn("Network operation in EDT");
        }
        CloseableHttpResponse response = null;
        try {
            String uri = GithubUrlUtil.getApiUrl(this.myHost) + path;
            response = this.doREST(uri, requestBody, headers, verb);
            if (this.myAborted) {
                throw new GithubOperationCanceledException();
            }
            GithubConnection.checkStatusCode(response, requestBody);
            HttpEntity entity = response.getEntity();
            if (entity == null) {
                ResponsePage responsePage = this.createResponse(response);
                return responsePage;
            }
            JsonElement ret = GithubConnection.parseResponse(entity.getContent());
            if (ret.isJsonNull()) {
                ResponsePage responsePage = this.createResponse(response);
                return responsePage;
            }
            String newPath = null;
            Header pageHeader = response.getFirstHeader("Link");
            if (pageHeader != null) {
                for (HeaderElement element : pageHeader.getElements()) {
                    NameValuePair rel = element.getParameterByName("rel");
                    if (rel == null || !"next".equals(rel.getValue())) continue;
                    String urlString = element.toString();
                    int begin = urlString.indexOf(60);
                    int end = urlString.lastIndexOf(62);
                    if (begin == -1 || end == -1) {
                        LOG.error("Invalid 'Link' header", new String[]{"{" + pageHeader.toString() + "}"});
                        break;
                    }
                    String url = urlString.substring(begin + 1, end);
                    String newUrl = GithubUrlUtil.removeProtocolPrefix(url);
                    int index = newUrl.indexOf(47);
                    newPath = newUrl.substring(index);
                    break;
                }
            }
            ResponsePage responsePage = this.createResponse(ret, newPath, response);
            return responsePage;
        }
        catch (SSLHandshakeException e) {
            if (e.getCause() instanceof ValidatorException) {
                LOG.info("Host SSL certificate is not trusted", (Throwable)e);
                throw new GithubOperationCanceledException("Host SSL certificate is not trusted", e);
            }
            throw e;
        }
        catch (IOException e) {
            if (this.myAborted) {
                throw new GithubOperationCanceledException("Operation canceled", e);
            }
            throw e;
        }
        finally {
            this.myRequest = null;
            if (response != null) {
                response.close();
            }
            if (!this.myReusable) {
                this.myClient.close();
            }
        }
    }

    private CloseableHttpResponse doREST(String uri, String requestBody, Collection<Header> headers, HttpVerb verb) throws IOException {
        HttpPost request;
        switch (verb) {
            case POST: {
                request = new HttpPost(uri);
                if (requestBody == null) break;
                request.setEntity((HttpEntity)new StringEntity(requestBody, ContentType.APPLICATION_JSON));
                break;
            }
            case PATCH: {
                request = new HttpPatch(uri);
                if (requestBody == null) break;
                ((HttpPatch)request).setEntity((HttpEntity)new StringEntity(requestBody, ContentType.APPLICATION_JSON));
                break;
            }
            case GET: {
                request = new HttpGet(uri);
                break;
            }
            case DELETE: {
                request = new HttpDelete(uri);
                break;
            }
            case HEAD: {
                request = new HttpHead(uri);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown HttpVerb: " + verb.toString());
            }
        }
        for (Header header : headers) {
            request.addHeader(header);
        }
        this.myRequest = request;
        return this.myClient.execute((HttpUriRequest)request);
    }

    private static void checkStatusCode(CloseableHttpResponse response, String body) throws IOException {
        int code = response.getStatusLine().getStatusCode();
        switch (code) {
            case 200: 
            case 201: 
            case 202: 
            case 204: {
                return;
            }
            case 401: 
            case 402: 
            case 403: {
                GithubStatusCodeException error = GithubConnection.getStatusCodeException(response);
                Header headerOTP = response.getFirstHeader("X-GitHub-OTP");
                if (headerOTP != null) {
                    for (HeaderElement element : headerOTP.getElements()) {
                        if (!"required".equals(element.getName())) continue;
                        throw new GithubTwoFactorAuthenticationException(error.getMessage());
                    }
                }
                if (error.getError() != null && error.getError().containsReasonMessage("API rate limit exceeded")) {
                    throw new GithubRateLimitExceededException(error.getMessage());
                }
                throw new GithubAuthenticationException("Request response: " + error.getMessage());
            }
            case 400: 
            case 422: {
                LOG.info("body message:" + body);
                throw GithubConnection.getStatusCodeException(response);
            }
        }
        throw GithubConnection.getStatusCodeException(response);
    }

    private static GithubStatusCodeException getStatusCodeException(CloseableHttpResponse response) {
        StatusLine statusLine = response.getStatusLine();
        try {
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                GithubErrorMessage error = GithubApiUtil.fromJson(GithubConnection.parseResponse(entity.getContent()), GithubErrorMessage.class);
                String message = statusLine.getReasonPhrase() + " - " + error.getMessage();
                return new GithubStatusCodeException(message, error, statusLine.getStatusCode());
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
        }
        return new GithubStatusCodeException(statusLine.getReasonPhrase(), statusLine.getStatusCode());
    }

    private static JsonElement parseResponse(InputStream githubResponse) throws IOException {
        InputStreamReader reader = new InputStreamReader(githubResponse, CharsetToolkit.UTF8_CHARSET);
        try {
            JsonElement jsonElement = new JsonParser().parse((Reader)reader);
            return jsonElement;
        }
        catch (JsonParseException jse) {
            throw new GithubJsonException("Couldn't parse GitHub response", jse);
        }
        finally {
            ((Reader)reader).close();
        }
    }

    private ResponsePage createResponse(CloseableHttpResponse response) throws GithubOperationCanceledException {
        if (this.myAborted) {
            throw new GithubOperationCanceledException();
        }
        return new ResponsePage(null, null, response.getAllHeaders());
    }

    private ResponsePage createResponse(JsonElement ret, String path, CloseableHttpResponse response) throws GithubOperationCanceledException {
        if (this.myAborted) {
            throw new GithubOperationCanceledException();
        }
        return new ResponsePage(ret, path, response.getAllHeaders());
    }

    private static class PreemptiveBasicAuthInterceptor
    implements HttpRequestInterceptor {
        private PreemptiveBasicAuthInterceptor() {
        }

        public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
            CredentialsProvider provider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
            Credentials credentials = provider.getCredentials(AuthScope.ANY);
            if (credentials != null) {
                request.addHeader(new BasicScheme(Consts.UTF_8).authenticate(credentials, request, context));
            }
        }
    }

    private static class ResponsePage {
        private final JsonElement myResponse;
        private final String myNextPage;
        private final Header[] myHeaders;

        public ResponsePage(JsonElement response, String next, Header[] headers) {
            this.myResponse = response;
            this.myNextPage = next;
            this.myHeaders = headers;
        }

        public JsonElement getJsonElement() {
            return this.myResponse;
        }

        public String getNextPage() {
            return this.myNextPage;
        }

        public Header[] getHeaders() {
            return this.myHeaders;
        }
    }

    public static class PagedRequest<T> {
        private String myNextPage;
        private final Collection<Header> myHeaders;
        private final Class<T> myResult;
        private final Class<? extends DataConstructor[]> myRawArray;

        public PagedRequest(String path, Class<T> result, Class<? extends DataConstructor[]> rawArray, Header ... headers) {
            this.myNextPage = path;
            this.myResult = result;
            this.myRawArray = rawArray;
            this.myHeaders = Arrays.asList(headers);
        }

        public List<T> next(GithubConnection connection) throws IOException {
            if (this.myNextPage == null) {
                throw new NoSuchElementException();
            }
            String page = this.myNextPage;
            this.myNextPage = null;
            ResponsePage response = connection.request(page, null, this.myHeaders, HttpVerb.GET);
            if (response.getJsonElement() == null) {
                throw new GithubConfusingException("Empty response");
            }
            if (!response.getJsonElement().isJsonArray()) {
                throw new GithubJsonException("Wrong json type: expected JsonArray", new Exception(response.getJsonElement().toString()));
            }
            this.myNextPage = response.getNextPage();
            ArrayList<T> result = new ArrayList<T>();
            for (DataConstructor raw : GithubApiUtil.fromJson((JsonElement)response.getJsonElement().getAsJsonArray(), this.myRawArray)) {
                result.add(GithubApiUtil.createDataFromRaw(raw, this.myResult));
            }
            return result;
        }

        public boolean hasNext() {
            return this.myNextPage != null;
        }

        public List<T> getAll(GithubConnection connection) throws IOException {
            ArrayList<T> result = new ArrayList<T>();
            while (this.hasNext()) {
                result.addAll(this.next(connection));
            }
            return result;
        }
    }

    private static enum HttpVerb {
        GET,
        POST,
        DELETE,
        HEAD,
        PATCH;

    }
}

